<?php
  
  use Api\Controllers\Auth\LoginController as AuthLoginController;
  use Api\Controllers\Auth\RegisterController as AuthRegisterController;
  use Api\Controllers\Auth\SessionController as AuthSessionController;
  use Api\Controllers\Auth\GameSessionController as AuthGameSessionController;
	use Api\Controllers\Auth\TfaController as AuthTfaController;
	use Api\Controllers\CommandLogController;
	use Api\Controllers\CreditController;
	use Api\Controllers\Integration\Ai\AiCommandController;
	use Api\Controllers\Integration\LeaderosId\InGameController;
	use Api\Controllers\Store\DonationController as StoreDonationController;
  use Api\Controllers\Integration\Discord\RoleController as DiscordRoleController;
  use Api\Controllers\Store\BuyController as StoreBuyController;
  use Api\Controllers\Store\ListingController as StoreListingController;
  use Api\Controllers\Store\ProductController as StoreProductController;
	use Api\Controllers\Store\CategoryController as StoreCategoryController;
	use Api\Controllers\Bazaar\StorageItemController as BazaarStorageItemController;
	use Api\Controllers\Bazaar\ServerController as BazaarServerController;
  use Api\Controllers\Support\TicketController;
  use Api\Controllers\Support\CategoryController as SupportCategoryController;
  use Api\Controllers\Support\AnswerController as SupportAnswerController;
  use Api\Controllers\Support\TicketMessageController;
  use Api\Controllers\UserController;
  use Api\Controllers\Integration\Discord\UserController as DiscordUserController;
  use Api\Controllers\Integration\Discord\SettingsController as DiscordSettingsController;
	use Api\Controllers\UserRoleController;
	use Api\Controllers\VoteLinkController;
  use Pecee\SimpleRouter\SimpleRouter as Router;
	
  /**
   * Auth routes
   */
  Router::group([
    'prefix' => '/auth'
  ], function () {
    Router::post('/login', [AuthLoginController::class, 'login'])->name('api.auth.login');
    Router::post('/register', [AuthRegisterController::class, 'register'])->name('api.auth.register');
    Router::get('/sessions/{token}', [AuthSessionController::class, 'show'])->name('api.auth.sessions.show');
    Router::post('/sessions', [AuthSessionController::class, 'store'])->name('api.auth.sessions.store');
    Router::post('/game-sessions', [AuthGameSessionController::class, 'check'])->name('api.auth.game-sessions.check');
    Router::post('/tfa/verify', [AuthTfaController::class, 'verify'])->name('api.auth.tfa.verify');
  });
  
  /**
   * Store routes
   */
  Router::group([
    'prefix' => '/store'
  ], function () {
    Router::post('/buy', [StoreBuyController::class, 'buy'])->name('api.store.buy');
    Router::get('/listing', [StoreListingController::class, 'index'])->name('api.store.listing');
    Router::get('/donations', [StoreDonationController::class, 'index'])->name('api.store.donations.index');

    Router::get('/products', [StoreProductController::class, 'index'])->name('api.store.products.index');
    Router::get('/products/{id}', [StoreProductController::class, 'show'])->name('api.store.products.show');
    
    Router::get('/categories', [StoreCategoryController::class, 'index'])->name('api.store.categories.index');
    Router::get('/categories/{id}', [StoreCategoryController::class, 'show'])->name('api.store.categories.show');
	});
  
  /**
   * Bazaar routes
   */
  Router::group([
    'prefix' => '/bazaar'
  ], function () {
    Router::get('/storages/{user}/items', [BazaarStorageItemController::class, 'index'])->name('api.bazaar.storage.items.index');
    Router::post('/storages/{user}/items', [BazaarStorageItemController::class, 'store'])->name('api.bazaar.storage.items.store');
    Router::delete('/storages/{user}/items/{id}', [BazaarStorageItemController::class, 'destroy'])->name('api.bazaar.storage.items.destroy');

    Router::get('/servers', [BazaarServerController::class, 'index'])->name('api.bazaar.servers.index');
  });
  
  /**
   * Credits routes
   */
  Router::group([
    'prefix' => '/credits',
  ], function () {
    Router::get('/', [CreditController::class, 'show'])->name('api.credits.show');
    Router::post('/add', [CreditController::class, 'add'])->name('api.credits.add');
    Router::post('/remove', [CreditController::class, 'remove'])->name('api.credits.remove');
    Router::post('/send', [CreditController::class, 'send'])->name('api.credits.set');
    Router::post('/set', [CreditController::class, 'set'])->name('api.credits.set');
  });
  
  /**
   * Users routes
   */
  Router::group([
    'prefix' => '/users'
  ], function () {
    Router::get('/', [UserController::class, 'show'])->name('api.users.show');
    Router::get('/{user}/tickets', [UserController::class, 'tickets'])->name('api.users.tickets');
    Router::get('/{user}/orders', [UserController::class, 'orders'])->name('api.users.orders');
	  
		// User roles
	  Router::get('/{user}/roles', [UserRoleController::class, 'index'])->name('api.users.roles.index');
	  Router::post('/{user}/roles', [UserRoleController::class, 'store'])->name('api.users.roles.store');
	  Router::patch('/{user}/roles/{id}', [UserRoleController::class, 'update'])->name('api.users.roles.update');
	  Router::delete('/{user}/roles/{id}', [UserRoleController::class, 'destroy'])->name('api.users.roles.destroy');
  });
  
  /**
   * Support routes
   */
  Router::group([
    'prefix' => '/support'
  ], function () {
    Router::get('/tickets/{ticketID}/messages', [TicketMessageController::class, 'index'])->name('api.support.tickets.messages.index');
    Router::get('/tickets/{ticketID}/messages/{id}', [TicketMessageController::class, 'show'])->name('api.support.tickets.messages.show');
    Router::post('/tickets/{ticketID}/messages', [TicketMessageController::class, 'store'])->name('api.support.tickets.messages.store');
    Router::post('/tickets/{id}/close', [TicketController::class, 'close'])->name('api.support.tickets.close');
    Router::resource('/tickets', TicketController::class)->name('api.support.tickets');
    Router::resource('/categories', SupportCategoryController::class)->name('api.support.categories');
    Router::resource('/answers', SupportAnswerController::class)->name('api.support.answers');
  });
  
  /**
   * Vote routes
   */
  Router::get('/vote-links', [VoteLinkController::class, 'index'])->name('api.vote-links.index');

/**
 * Integrations routes
 */
Router::group([
  'prefix' => '/integrations'
], function () {
  /**
   * Discord Integration routes
   */
  Router::group([
    'prefix' => '/discord'
  ], function () {
    Router::get('/users/{discordUserID}', [DiscordUserController::class, 'show'])->name('api.integrations.discord.users.show');
    Router::get('/settings', [DiscordSettingsController::class, 'get'])->name('api.integrations.discord.settings.get');
    Router::get('/roles', [DiscordRoleController::class, 'index'])->name('api.integrations.discord.roles.index');
  });
	
	/**
	 * LeaderOS ID Integration routes
	 */
	Router::group([
		'prefix' => '/leaderos-id'
	], function () {
		Router::post('/verify-ingame', [InGameController::class, 'verify'])->name('api.integrations.leaderos-id.ingame.verify');
	});
	
	/**
	 * LeaderOS AI Integration routes
	 */
	Router::group([
		'prefix' => '/leaderos-ai'
	], function () {
		Router::post('/ai-command/ingame', [AiCommandController::class, 'ingame'])->name('api.integrations.leaderos-ai.ai-command.ingame');
		Router::post('/ai-command/discord', [AiCommandController::class, 'discord'])->name('api.integrations.leaderos-ai.ai-command.discord');
	});
});

/**
 * Command Logs routes
 */
Router::post('/command-logs/validate', [CommandLogController::class, 'validate'])->name('api.command-logs.validate');
Router::post('/command-logs/retry', [CommandLogController::class, 'retry'])->name('api.command-logs.retry');
