<?php
  
  namespace Api\Controllers\Auth;
  
  use Api\Core\Controller;
  use PDO;
  
  class LoginController extends Controller
  {
    public function login()
    {
      validate([
        'username' => 'required',
        'password' => 'required',
	      'ip' => 'required|ip',
	      'useragent' => 'required'
      ]);
      
			$username = input('username');
			$password = input('password');
			$ip = input('ip');
			$useragent = input('useragent');
			
      $login = db()->prepare("SELECT id, password FROM Accounts WHERE username = ?");
      $login->execute(array($username));
      $user = $login->fetch(PDO::FETCH_ASSOC);
			
      if ($login->rowCount() > 0) {
        if (checkPassword(settings("passwordType"), $password, $user["password"])) {
	        $session = db()->prepare("SELECT loginToken, isTfaVerified FROM AccountSessions WHERE accountID = ? AND creationIP = ? AND expiryDate > ? AND useragent = ?");
	        $session->execute([$user['id'], $ip, date('Y-m-d H:i:s'), $useragent]);
	        $session = $session->fetch(PDO::FETCH_ASSOC);
	        
	        // $isTfaVerified = null => TFA NOT REQUIRED
	        // $isTfaVerified = false => TFA REQUIRED
	        // $isTfaVerified = true => TFA VERIFIED NOT REQUIRED
	        $isTfaVerified = null;
	        if (!$session) {
						if (!moduleIsDisabled('tfa')) {
							$tfaKeys = db()->prepare("SELECT * FROM AccountTfaKeys WHERE accountID = ?");
							$tfaKeys->execute([$user['id']]);
							$tfaKeys = $tfaKeys->fetch();
							if ($tfaKeys) {
								$isTfaVerified = false;
							}
						}
						
						$loginToken = md5(uniqid(mt_rand(), true));
						$insertAccountSessions = db()->prepare("INSERT INTO AccountSessions (accountID, loginToken, useragent, isTfaVerified, creationIP, expiryDate, creationDate) VALUES (?, ?, ?, ?, ?, ?, ?)");
						$insertAccountSessions->execute(array($user["id"], $loginToken, $useragent, $isTfaVerified === null ? null : (int) $isTfaVerified, $ip, createDuration(1), date("Y-m-d H:i:s")));
					} else {
						if (!moduleIsDisabled('tfa')) {
							$isTfaVerified = !($session["isTfaVerified"] == '0');
						}
						$loginToken = $session["loginToken"];
						$updateAccountsSessions = db()->prepare("UPDATE AccountSessions SET expiryDate = ? WHERE accountID = ? AND loginToken = ?");
						$updateAccountsSessions->execute(array(createDuration(1), $user["id"], $loginToken));
					}
          
          api()->success([
            'token' => $loginToken,
	          'isTfaRequired' => isset($isTfaVerified) && $isTfaVerified === false,
          ]);
        }
        else {
          api()->unauthorized('WRONG_PASSWORD', 'Wrong password!');
        }
      }
      else {
        api()->notFound('USER_NOT_FOUND', 'User not found!');
      }
    }
  }