<?php
  
  namespace Api\Controllers\Auth;
  
  use Api\Core\Controller;
  use PDO;
  
  class RegisterController extends Controller
  {
    public function register()
    {
      validate([
        'email' => 'nullable',
        'username' => 'required',
        'password' => 'required',
	      'ip' => 'required|ip',
	      'useragent' => 'required'
      ]);
			
			$email = input("email");
			$username = input("username");
			$password = input("password");
			$ip = input("ip");
			$useragent = input("useragent");
			
			if ($email !== null && !filter_var($email, FILTER_VALIDATE_EMAIL)) {
				api()->error('INVALID_EMAIL', 'Invalid email address!');
			}
	    
	    if (!validate_username($username)) {
		    api()->error('INVALID_USERNAME', 'Invalid username!');
	    }
	    
	    if (strlen($password) < 4 || strlen($password) > 32 || !preg_match('/^[!-~]*$/', $password)) {
		    api()->error('INVALID_PASSWORD', 'Invalid password!');
	    }
	    
	    $usernameValid = db()->prepare("SELECT COUNT(id) FROM Accounts WHERE username = ?");
	    $usernameValid->execute(array($username));
	    $usernameCount = $usernameValid->fetchColumn();
      if ($usernameCount > 0) {
        api()->error('USERNAME_ALREADY_EXIST', 'Username already exists!', 409);
      }
	    
	    if ($email !== null) {
		    $emailValid = db()->prepare("SELECT COUNT(id) FROM Accounts WHERE email = ?");
		    $emailValid->execute(array($email));
		    $emailCount = $emailValid->fetchColumn();
		    if ($emailCount > 0) {
			    api()->error('EMAIL_ALREADY_EXIST', 'Email already exists!', 409);
		    }
	    }
			
      if (settings("registerLimit") != -1) {
	      $ipCount = db()->prepare("SELECT COUNT(id) FROM Accounts WHERE creationIP = ?");
	      $ipCount->execute(array($ip));
	      $ipCount = $ipCount->fetchColumn();
	      
	      if ($ipCount >= (int)settings("registerLimit")) {
          api()->error('REGISTER_LIMIT', 'You have reached the limit of registrations!', 403);
	      }
      }
      
      $loginToken = md5(uniqid(mt_rand(), true));
      $password = createPassword(settings("passwordType"), $password);
      
      $insertAccounts = db()->prepare("INSERT INTO Accounts (username, realname, email, password, isVerified, creationIP, creationDate) VALUES (?, ?, ?, ?, ?, ?, ?)");
      $insertAccounts->execute(array(strtolower($username), $username, $email, $password, (!moduleIsDisabled("email_verification") ? "0" : "1"), $ip, date("Y-m-d H:i:s")));
      $userID = db()->lastInsertId();
      $insertAccountSessions = db()->prepare("INSERT INTO AccountSessions (accountID, loginToken, useragent, creationIP, expiryDate, creationDate) VALUES (?, ?, ?, ?, ?, ?)");
      $insertAccountSessions->execute(array($userID, $loginToken, $useragent, $ip, createDuration(1), date("Y-m-d H:i:s")));
			
			api()->success([
				'token' => $loginToken
			]);
    }
  }