<?php
  
  namespace Api\Controllers\Bazaar;
  
  use Api\Core\Controller;
  use Api\Services\UserService;
  use PDO;
  
  class StorageItemController extends Controller
  {
    public function index($user)
    {
      $user = UserService::getByID($user);
      if (!$user) api()->notFound('USER_NOT_FOUND', 'User not found!');

      $serverID = _get("serverID");
      if ($serverID) {
        $items = db()->prepare("SELECT * FROM BazaarItems WHERE owner = ? AND price = ? AND sold = ? AND serverID = ?");
        $items->execute([$user["id"], 0, 0, $serverID]);
      }
      else {
        $items = db()->prepare("SELECT * FROM BazaarItems WHERE owner = ? AND price = ? AND sold = ?");
        $items->execute([$user["id"], 0, 0]);
      }
      $items = $items->fetchAll(PDO::FETCH_ASSOC);
      response()->json($items);
    }
    
    public function store($user)
    {
      validate([
        'serverID' => 'required|numeric',
        'itemID' => 'required',
        'modelID' => 'nullable',
        'name' => 'nullable',
        'lore' => 'nullable',
        'amount' => 'required|numeric',
        'durability' => 'required|numeric',
        'maxDurability' => 'required|numeric',
        'enchantments' => 'nullable',
        'base64' => 'required',
      ]);

      $user = UserService::getByID($user);
      if (!$user) api()->notFound('USER_NOT_FOUND', 'User not found!');

      $base64 = str_replace(' ', '+', input('base64'));
      
      $addItem = db()->prepare("INSERT INTO BazaarItems (owner, serverID, itemID, modelID, name, lore, amount, durability, maxDurability, enchantments, base64, creationDate) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
      $addItem = $addItem->execute([$user['id'], input('serverID'), input('itemID'), input('modelID'), input('name'), input('lore'), input('amount'), input('durability'), input('maxDurability'), input('enchantments'), $base64, date('Y-m-d H:i:s')]);
      
      if ($addItem) api()->success();

      api()->error('INSERT_ERROR', 'Error while inserting data!');
    }
    
    public function destroy($user, $id)
    {
	    $user = UserService::getByID($user);
	    if (!$user) api()->notFound('USER_NOT_FOUND', 'User not found!');
			
			$item = db()->prepare("SELECT * FROM BazaarItems WHERE sold = ? AND price = ? AND owner = ? AND id = ?");
			$item->execute([0, 0, $user['id'], $id]);
			$item = $item->fetch();
			if (!$item) api()->error('DELETE_ERROR', 'Error while deleting data!');
			
      $deleteItem = db()->prepare("DELETE FROM BazaarItems WHERE owner = ? AND id = ?");
      $deleteItem = $deleteItem->execute([$user['id'], $id]);
      
      if ($deleteItem) api()->success();

      api()->error('DELETE_ERROR', 'Error while deleting data!');
    }
  }