<?php
  
  namespace Api\Controllers;
  
  use Api\Core\Controller;

  class BirFaturaController extends Controller
  {
		private function getCleanFullName($firstName, $lastName, $username): string
		{
			// Ad ve soyadı birleştir
			$fullName = $firstName . ' ' . $lastName;
			
			// Sadece harf (Türkçe karakterler dahil) ve boşluğa izin ver
			$cleaned = preg_replace('/[^a-zA-ZçÇğĞıİöÖşŞüÜ\s]/u', '', $fullName);
			
			// Baştaki ve sondaki boşlukları temizle
			$cleaned = trim($cleaned);
			
			// Sonuç boşsa kullanıcı adını döndür
			return $cleaned !== '' ? $cleaned : $username;
		}
		
		private function getCleanPhoneNumber($phoneNumber): string
		{
			// Sadece rakamları ve artı işaretini tut
			$cleaned = preg_replace('/[^\d+]/', '', $phoneNumber);
			
			// Eğer temizlenmiş numara boşsa, varsayılan bir değer döndür
			return $cleaned !== '' ? $cleaned : '05555555555';
		}
		
    public function orderStatus()
    {
      response()->json([
        "OrderStatus" => [
          [
            "Id" => 1,
            "Value" => "Onaylandı"
          ],
          [
            "Id" => 2,
            "Value" => "İptal Edildi"
          ]
        ]
      ]);
    }

    public function paymentMethods()
    {
      response()->json([
        "PaymentMethods" => [
          [
            "Id" => 1,
            "Value" => "Kredi Kartı"
          ],
          [
            "Id" => 2,
            "Value" => "Mobil Ödeme"
          ],
          [
            "Id" => 3,
            "Value" => "EFT"
          ],
          [
            "Id" => 4,
            "Value" => "Papara"
          ],
          [
            "Id" => 5,
            "Value" => "Ininal"
          ]
        ]
      ]);
    }

    public function orders()
    {
      $orderList = [];
      $orders = db()->prepare("SELECT O.*, A.email, A.username, ACI.firstName, ACI.lastName, ACI.phoneNumber FROM Orders O INNER JOIN Accounts A ON A.id = O.accountID INNER JOIN AccountContactInfo ACI ON A.id = ACI.accountID WHERE O.status = ? AND O.earnings > 0 AND O.creationDate >= ?");
      $orders->execute([1, moduleSettings('birfatura', 'lastCheck')]);
      $orders = $orders->fetchAll();
      foreach($orders as $readOrder) {
        array_push($orderList, array (
            'OrderId' => $readOrder["id"],
            'OrderCode' => $readOrder["id"],
            'OrderDate' => date("d.m.Y H:i:s", strtotime($readOrder["creationDate"])),
            'CustomerId' => $readOrder["accountID"],
            'BillingName' => self::getCleanFullName($readOrder["firstName"], $readOrder["lastName"], $readOrder["username"]),
            'BillingAddress' => '*******************',
            'BillingTown' => '********',
            'BillingCity' => 'İstanbul',
            'BillingMobilePhone' => self::getCleanPhoneNumber($readOrder["phoneNumber"]),
            'SSNTCNo' => '11111111111',
            'Email' => $readOrder["email"],
            'ShippingName' => self::getCleanFullName($readOrder["firstName"], $readOrder["lastName"], $readOrder["username"]),
            'ShippingAddress' => '*******************',
            'ShippingTown' => '********',
            'ShippingCity' => 'İstanbul',
            'ShippingPhone' => self::getCleanPhoneNumber($readOrder["phoneNumber"]),
            'PaymentTypeId' => 1,
            'Currency' => 'TRY',
            'TotalPaidTaxExcluding' => (int)$readOrder["earnings"]/1.20,
            'TotalPaidTaxIncluding' => (int)$readOrder["earnings"],
            'ProductsTotalTaxExcluding' => (int)$readOrder["earnings"]/1.20,
            'ProductsTotalTaxIncluding' => (int)$readOrder["earnings"],
            'OrderDetails' => array (
              0 =>
                array (
                  'ProductId' => 1,
                  'ProductCode' => 'SIPARIS',
                  'ProductName' => 'Sipariş #' . $readOrder["id"],
                  'ProductQuantityType' => 'Adet',
                  'ProductQuantity' => 1.0,
                  'VatRate' => 20,
                  'ProductUnitPriceTaxExcluding' => (int)$readOrder["earnings"]/1.20,
                  'ProductUnitPriceTaxIncluding' => (int)$readOrder["earnings"]
                ),
            ),
          )
        );
      }
      //updateSetting('birfaturaLastCheck', date("Y-m-d H:i:s"));

      response()->json([
        'Orders' => $orderList
      ]);
    }
  }