<?php
  
  namespace Api\Controllers;
  
  use Api\Core\Controller;
  use Api\Services\CommandService;
  use PDO;
  
  class CommandLogController extends Controller
  {
    public function validate()
    {
      validate([
        'token' => 'required',
        'commands' => 'required|array'
      ]);

      $server = db()->prepare("SELECT * FROM Servers WHERE consoleToken = ?");
      $server->execute([input('token')]);
      if ($server->rowCount() == 0)
        response()->json([
          'status' => false,
          'error' => 'INVALID_TOKEN'
        ]);
      $server = $server->fetch();

      $logIDs = input('commands');
      $queryData = array_merge([$server["id"]], ['sending'], $logIDs);
	    
	    $getCommandLogs = db()->prepare("SELECT L.id, L.dataType, L.dataID, L.command, L.identifier FROM CommandLogs L INNER JOIN ProductCommands C ON C.id = L.commandID WHERE C.serverID = ? AND L.status = ? AND L.id IN (".implode(',', array_fill(0, count($logIDs), '?')).")");
	    $getCommandLogs->execute($queryData);
      $getCommandLogs = array_map(function($log) {
        $command = $log["command"];
        $identifier = $log["identifier"];
				
        return [
          'logID' => $log["id"],
          'username' => $identifier,
	        'authProvider' => settings('loginProvider'),
          'command' => $command
        ];
      }, $getCommandLogs->fetchAll(PDO::FETCH_ASSOC));
			
			// Set status as 'completed' for the commands
			$validatedLogIDs = array_column($getCommandLogs, 'logID');
      $updateCommandLogs = db()->prepare("UPDATE CommandLogs SET status = ?, updatedAt = ? WHERE id IN (".implode(',', array_fill(0, count($validatedLogIDs), '?')).")");
      $updateCommandLogs->execute(array_merge(['completed', datetime()], $validatedLogIDs));

      response()->json([
        'commands' => $getCommandLogs
      ]);
    }
		
		public function retry()
		{
			$unsuccessfulLogs = db()->query("SELECT CL.id, CL.command, PC.serverID FROM CommandLogs CL INNER JOIN ProductCommands PC ON PC.id = CL.commandID WHERE (CL.status = 'error' OR (CL.status = 'waiting' AND CL.updatedAt <= '". date('Y-m-d H:i:s', strtotime('-1 minutes')) ."')) AND CL.retry <= 60");
			$unsuccessfulLogs = $unsuccessfulLogs->fetchAll(PDO::FETCH_ASSOC);
			$servers = [];
			
			foreach ($unsuccessfulLogs as $unsuccessfulLog) {
				$servers[$unsuccessfulLog["serverID"]][] = [
					'command' => $unsuccessfulLog["command"],
					'logID' => $unsuccessfulLog["id"]
				];
			}
			
			foreach ($servers as $serverID => $commands) {
				$server = db()->prepare("SELECT * FROM Servers WHERE id = ?");
				$server->execute(array($serverID));
				$server = $server->fetch();
				
				if (!$server) continue;
				
				$consoleIP = $server["ip"];
				$consoleType = $server["consoleID"];
				$consolePort = $server["consolePort"];
				$consolePassword = $server["consolePassword"];
				$consoleToken = $server["consoleToken"];
				
				$updateCommandLogs = db()->prepare("UPDATE CommandLogs SET status = ?, updatedAt = ?, retry = retry + 1 WHERE id = ?");
				foreach ($commands as $command) {
					$updateCommandLogs->execute(['sending', datetime(), $command["logID"]]);
				}
				
				CommandService::sendCommand($consoleIP, $consolePort, $consolePassword, $consoleToken, $consoleType, $commands);
			}
		}
  }