<?php

namespace Api\Controllers\Integration\Ai;

use Api\Core\Controller;
use Curl\Curl;
use PDO;

class AiCommandController extends Controller
{
  public function ingame()
  {
	  validate([
		  'prompt' => 'required',
		  'language' => 'nullable'
	  ]);
	  
	  // Send request to LeaderOS AI API
	  $curl = new Curl();
	  $curl->setHeader('Content-Type', 'application/json');
	  $curl->setHeader('Accept', 'application/json');
	  $curl->setHeader('X-Api-Key', settings('apiKey'));
	  $curl->post("https://ai-service-api.leaderos.net/ingame-ai-command", [
		  "prompt" => input('prompt'),
		  "language" => input('language'),
	  ]);
		
		if ($curl->error) {
			api()->badRequest('ERROR_REQUEST', 'Something went wrong! Please try again later.');
		}
		if (isset($curl->response->error)) {
			api()->badRequest($curl->response->error);
		}
		if (!isset($curl->response->message)) {
			api()->badRequest('ERROR_RESPONSE', 'Something went wrong! Please try again later.');
		}
	  
	  api()->success([
	    'message' => $curl->response->message
	  ]);
  }
	
	public function discord()
	{
		validate([
			'prompt' => 'required',
			'language' => 'nullable'
		]);
		
		// Send request to LeaderOS AI API
		$curl = new Curl();
		$curl->setHeader('Content-Type', 'application/json');
		$curl->setHeader('Accept', 'application/json');
		$curl->setHeader('X-Api-Key', settings('apiKey'));
		$curl->post("https://ai-service-api.leaderos.net/discord-ai-command", [
			"prompt" => input('prompt'),
			"language" => input('language'),
		]);
		
		if ($curl->error) {
			api()->badRequest('ERROR_REQUEST', 'Something went wrong! Please try again later.');
		}
		if (isset($curl->response->error)) {
			api()->badRequest($curl->response->error);
		}
		if (!isset($curl->response->message)) {
			api()->badRequest('ERROR_RESPONSE', 'Something went wrong! Please try again later.');
		}
		
		api()->success([
			'message' => $curl->response->message
		]);
	}
}