<?php

namespace Api\Controllers\Integration\LeaderosId;

use Api\Core\Controller;
use Curl\Curl;
use PDO;

class InGameController extends Controller
{
  public function verify()
  {
	  validate([
		  'code' => 'required',
		  'username' => 'required',
		  'realname' => 'required',
	  ]);
	  
	  $verifyRequest = new Curl();
	  $verifyRequest->setHeader('X-Api-Key', settings('apiKey'));
	  $verifyRequest->post("https://id.leaderos.net/api/verify-ingame", [
			'code' => input('code'),
		  'username' => input('username'),
		  'realname' => input('realname'),
	  ]);
		if ($verifyRequest->error) {
			api()->badRequest('ERROR_REQUEST', 'Something went wrong! Please try again later.');
		}
		
		$verifyResponse = $verifyRequest->response;
		
		if (!isset($verifyResponse->status)) {
			api()->badRequest('ERROR_RESPONSE', 'Something went wrong! Please try again later.');
		}
		
		if (!$verifyResponse->status) {
			$errorCode = $verifyResponse->error ?? null;
			if ($errorCode === null) {
				api()->badRequest('INVALID_CODE', 'Invalid code!');
			} else {
				api()->badRequest($errorCode);
			}
		}

    api()->success();
  }
}