<?php
  
  namespace Api\Controllers\Store;
  
  use Api\Core\Controller;
  use PDO;
  
  class CategoryController extends Controller
  {
    public function index()
    {
      $categories = db()->prepare("SELECT * FROM ProductCategories WHERE isActive = ? ORDER BY priority DESC");
      $categories->execute([1]);
      $categories = $categories->fetchAll(PDO::FETCH_ASSOC);
      response()->json($categories);
    }
    
    public function show($id)
    {
      $category = db()->prepare("SELECT * FROM ProductCategories WHERE id = ?");
      $category->execute([$id]);
      $category = $category->fetch(PDO::FETCH_ASSOC);
      $categories = db()->prepare("SELECT * FROM ProductCategories WHERE parentID = ?");
      $categories->execute([$id]);
      $categories = $categories->fetchAll(PDO::FETCH_ASSOC);
      $products = db()->prepare("SELECT * FROM Products WHERE categoryID = ?");
      $products->execute([$id]);
      $products = $products->fetchAll(PDO::FETCH_ASSOC);
      
      response()->json(
        $category + ['categories' => $categories] + ['products' => $products]
      );
    }
  }