<?php
  
  namespace Api\Controllers\Store;
  
  use Api\Core\Controller;
  use PDO;
  
  class DonationController extends Controller
  {
    public function index()
    {
      $type = _get('type');
      $limit = _get('limit');
      $donates = null;

      if (!$type) api()->badRequest('TYPE_IS_REQUIRED', 'Type is required');
      if (!$limit) api()->badRequest('LIMIT_IS_REQUIRED', 'Limit is required');
      if ($type != 'top-alltime' && $type != 'top-annual' && $type != 'top-monthly' && $type != 'top-daily' && $type != 'latest')
        api()->badRequest('INVALID_TYPE', 'Invalid type!');
      if ($limit < 1 || $limit > 10) api()->badRequest('INVALID_LIMIT_VALUE', 'Invalid limit!');

      if ($type == 'top-alltime') {
        $donates = db()->prepare("SELECT A.realname, A.username, SUM(O.total) as total FROM Orders O INNER JOIN Accounts A ON O.accountID = A.id WHERE O.status = ? GROUP BY O.accountID HAVING total > 0 ORDER BY total DESC LIMIT $limit");
        $donates->execute([1]);
      }
      if ($type == 'top-annual') {
        $donates = db()->prepare("SELECT A.realname, A.username, SUM(O.total) as total FROM Orders O INNER JOIN Accounts A ON O.accountID = A.id WHERE O.status = ? AND O.creationDate LIKE ? GROUP BY O.accountID HAVING total > 0 ORDER BY total DESC LIMIT $limit");
        $donates->execute([1, date("Y") . "%"]);
      }
      if ($type == 'top-monthly') {
        $donates = db()->prepare("SELECT A.realname, A.username, SUM(O.total) as total FROM Orders O INNER JOIN Accounts A ON O.accountID = A.id WHERE O.status = ? AND O.creationDate LIKE ? GROUP BY O.accountID HAVING total > 0 ORDER BY total DESC LIMIT $limit");
        $donates->execute([1, date("Y-m") . "%"]);
      }
      if ($type == 'top-daily') {
        $donates = db()->prepare("SELECT A.realname, A.username, SUM(O.total) as total FROM Orders O INNER JOIN Accounts A ON O.accountID = A.id WHERE O.status = ? AND O.creationDate LIKE ? GROUP BY O.accountID HAVING total > 0 ORDER BY total DESC LIMIT $limit");
        $donates->execute([1, date("Y-m-d") . "%"]);
      }
      if ($type == 'latest') {
        $donates = db()->prepare("SELECT A.realname, A.username, O.total, O.creationDate FROM Orders O INNER JOIN Accounts A ON A.id = O.accountID WHERE O.status = ? ORDER BY O.id DESC LIMIT $limit");
        $donates->execute([1]);
      }
      $donates = array_map(function ($donate) {
        $data = [
          'display_name' => $donate['realname'],
          'username' => $donate['username'],
          'total' => formatMoney($donate['total']),
          'raw_total' => $donate['total'],
          'currency' => settings('currency'),
        ];

        if (isset($donate['creationDate']))
          $data['date'] = $donate['creationDate'];

        return $data;
      }, $donates->fetchAll(PDO::FETCH_ASSOC));

      response()->json($donates);
    }
  }