<?php
  
  namespace Api\Controllers\Store;
  
  use Api\Core\Controller;
  use Api\Services\CurrencyService;
  use Api\Services\ListingService;
  use Api\Services\UserService;
  use PDO;

  class ListingController extends Controller
  {
    public function index()
    {
	    $user = UserService::getByUsername(_get('username'));
	    
	    $purchasedProductsIDs = [];
	    if ($user) {
		    $purchasedProductsIDs = db()->prepare("SELECT productID FROM PurchasedProducts WHERE accountID = ? AND (expiresAt > ? OR expiresAt IS NULL)");
		    $purchasedProductsIDs->execute(array($user["id"], date('Y-m-d H:i:s')));
		    $purchasedProductsIDs = $purchasedProductsIDs->fetchAll(PDO::FETCH_COLUMN);
	    }
			
      $categories = db()->prepare("SELECT * FROM ProductCategories WHERE isActive = ? ORDER BY priority DESC");
      $categories->execute([1]);
      $categories = $categories->fetchAll(PDO::FETCH_ASSOC);
			
			$filteredCategories = [];
	    
	    foreach ($categories as $category) {
		    $categoryRequiredProducts = db()->prepare("SELECT productID FROM ProductCategoryRequiredProducts WHERE categoryID = ?");
		    $categoryRequiredProducts->execute([$category["id"]]);
		    $categoryRequiredProducts = $categoryRequiredProducts->fetchAll(PDO::FETCH_COLUMN);
				
				if (count($categoryRequiredProducts) > 0 && empty(array_intersect($purchasedProductsIDs, $categoryRequiredProducts))) {
					continue;
				}
				
				$filteredCategories[] = $category;
	    }

      $products = db()->prepare("SELECT * FROM Products WHERE isActive = ? ORDER BY priority DESC");
      $products->execute([1]);
      $products = $products->fetchAll(PDO::FETCH_ASSOC);

      $tree = ListingService::buildTree($user, $filteredCategories, $products);

      response()->json([
        'categories' => $tree
      ]);
    }
  }