<?php
  
  namespace Api\Controllers\Store;
  
  use Api\Core\Controller;
  use PDO;
  
  class ProductController extends Controller
  {
    public function index()
    {
      $products = db()->prepare("SELECT * FROM Products WHERE isActive = ? ORDER BY priority DESC");
      $products->execute([1]);
      $products = $products->fetchAll(PDO::FETCH_ASSOC);
      response()->json($products);
    }
    
    public function show($id)
    {
      $product = db()->prepare("SELECT * FROM Products WHERE id = ? AND isActive = ?");
      $product->execute([$id, 1]);
      $product = $product->fetch(PDO::FETCH_ASSOC);
      response()->json($product);
    }
  }