<?php
  
  namespace Api\Controllers\Support;
  
  use Api\Core\Controller;
  use PDO;
  
  class TicketController extends Controller
  {
    public function index()
    {
      $tickets = db()->query('SELECT S.*, SP.name as categoryName FROM Supports S INNER JOIN SupportCategories SP ON SP.id = S.categoryID');
      $tickets = $tickets->fetchAll(PDO::FETCH_ASSOC);

      $tickets = array_map(function($ticket) {
        $messages = db()->prepare('SELECT id, accountID, message, writeLocation, creationDate FROM SupportMessages WHERE supportID = ?');
        $messages->execute([$ticket['id']]);
        $messages = $messages->fetchAll(PDO::FETCH_ASSOC);
        $ticket['messages'] = $messages;

        return $ticket;
      }, $tickets);

      
      response()->json($tickets);
    }
    
    public function show($id)
    {
      $ticket = db()->prepare('SELECT * FROM Supports WHERE id = ?');
      $ticket->execute([$id]);
      $ticket = $ticket->fetch(PDO::FETCH_ASSOC);

      if (!$ticket)
        api()->notFound('TICKET_NOT_FOUND', 'Ticket not found');

      $category = db()->prepare('SELECT * FROM SupportCategories WHERE id = ?');
      $category->execute([$ticket['categoryID']]);
      $category = $category->fetch(PDO::FETCH_ASSOC);
      $ticket['category'] = $category;

      $messages = db()->prepare('SELECT id, accountID, message, writeLocation, creationDate FROM SupportMessages WHERE supportID = ?');
      $messages->execute([$ticket['id']]);
      $messages = $messages->fetchAll(PDO::FETCH_ASSOC);
      $ticket['messages'] = $messages;
      
      response()->json($ticket);
    }
    
    public function store() {
      validate([
        'userID' => 'required',
        'categoryID' => 'required',
        'title' => 'required',
        'message' => 'required',
      ]);
      
      $insertTicket = db()->prepare('INSERT INTO Supports (title, accountID, categoryID, updateDate, creationDate) VALUES (?, ?, ?, ?, ?)');
      $insertTicket->execute([
        input('title'),
        input('userID'),
        input('categoryID'),
        date('Y-m-d H:i:s'),
        date('Y-m-d H:i:s'),
      ]);
      $ticketID = db()->lastInsertId();
      
      $insertTicketMessage = db()->prepare('INSERT INTO SupportMessages (supportID, accountID, message, creationDate) VALUES (?, ?, ?, ?)');
      $insertTicketMessage->execute([
        $ticketID,
        input('userID'),
        input('message'),
        date('Y-m-d H:i:s')
      ]);
      
      api()->success([
        'id' => $ticketID
      ]);
    }

    public function close($id) {
      $ticket = db()->prepare('SELECT * FROM Supports WHERE id = ?');
      $ticket->execute([$id]);
      $ticket = $ticket->fetch(PDO::FETCH_ASSOC);

      if (!$ticket)
        api()->notFound('TICKET_NOT_FOUND', 'Ticket not found');

      $updateTicket = db()->prepare('UPDATE Supports SET statusID = ? WHERE id = ?');
      $updateTicket->execute([4, $id]);

      api()->success([
        'id' => $id
      ]);
    }
  }