<?php
  
  namespace Api\Controllers\Support;
  
  use Api\Core\Controller;
  use PDO;
  
  class TicketMessageController extends Controller
  {
    public function index($ticketID)
    {
      $messages = db()->prepare('SELECT * FROM SupportMessages WHERE supportID = ?');
      $messages->execute([$ticketID]);
      $messages = $messages->fetchAll(PDO::FETCH_ASSOC);

      response()->json($messages);
    }

    public function show($ticketID, $id)
    {
      $ticketMessages = db()->prepare('SELECT * FROM SupportMessages WHERE supportID = ? AND id = ?');
      $ticketMessages->execute([$ticketID, $id]);
      $ticketMessages = $ticketMessages->fetch(PDO::FETCH_ASSOC);
      
      response()->json($ticketMessages);
    }
    
    public function store($ticketID) {
      validate([
        'userID' => 'required',
        'message' => 'required',
        'isAdmin' => 'default:false|required|boolean',
      ]);
      
      $insertTicketMessage = db()->prepare('INSERT INTO SupportMessages (supportID, accountID, message, writeLocation, creationDate) VALUES (?, ?, ?, ?, ?)');
      $insertTicketMessage->execute([
        $ticketID,
        input('userID'),
        input('message'),
        input('isAdmin') == "true" ? "2" : "1",
        date('Y-m-d H:i:s')
      ]);
      $id = db()->lastInsertId();
      
      api()->success([
        'id' => $id
      ]);
    }
  }