<?php
  
  namespace Api\Controllers;
  
  use Api\Core\Controller;
  use Api\Services\DiscordBotService;
  use Api\Services\UserService;
  use PDO;
  
  class UserController extends Controller
  {
    public function show()
    {
      $user = UserService::getByParams();
      if (!$user) api()->notFound('USER_NOT_FOUND', 'User not found!');
      
      unset($user['password']);
			
			$user["linkedAccounts"] = [];
			
	    if (settings('loginProvider') !== 'default') {
		    $user["linkedAccounts"][settings('loginProvider')] = $user["username"];
	    }
	    if (!moduleIsDisabled('account_linking')) { // Linked Accounts
		    $linkedAccounts = db()->prepare('SELECT L.identifier, P.slug as provider FROM LinkedAccounts L INNER JOIN AccountLinkingProviders P ON P.id = L.providerID WHERE L.accountID = ?');
		    $linkedAccounts->execute([$user["id"]]);
		    $linkedAccounts = $linkedAccounts->fetchAll(PDO::FETCH_ASSOC);

				foreach ($linkedAccounts as $linkedAccount) {
					$user["linkedAccounts"][$linkedAccount["provider"]] = $linkedAccount['identifier'];
				}
	    }
	    if (!moduleIsDisabled('discord')) { // For legacy discord bot
		    $discordUserData = db()->prepare("SELECT discordUserID FROM AccountDiscordData WHERE accountID = ?");
		    $discordUserData->execute([$user["id"]]);
		    $discordUserData = $discordUserData->fetch(PDO::FETCH_ASSOC);
				if ($discordUserData) {
					$user["linkedAccounts"]["discord"] = $discordUserData["discordUserID"];
				}
	    }
      
      response()->json($user);
    }
    
    public function tickets($user) {
	    $user = UserService::getByID($user);
      if (!$user) api()->notFound('USER_NOT_FOUND', 'User not found!');
      
      $tickets = db()->prepare("SELECT S.*, SP.name as categoryName FROM Supports S INNER JOIN SupportCategories SP ON SP.id = S.categoryID WHERE S.accountID = ?");
      $tickets->execute([$user['id']]);
      $tickets = $tickets->fetchAll(PDO::FETCH_ASSOC);
      
      response()->json($tickets);
    }
    
    public function orders($user) {
	    $user = UserService::getByID($user);
      if (!$user) api()->notFound('USER_NOT_FOUND', 'User not found!');
      
      $orders = db()->prepare("SELECT * FROM Orders WHERE accountID = ?");
      $orders->execute([$user['id']]);
      $orders = $orders->fetchAll(PDO::FETCH_ASSOC);
      
      response()->json($orders);
    }
  }