<?php
	namespace Api\Jobs;
	
	use Api\Core\Jobs\Job;
	use Api\Libs\Discord;
	
	class ResyncDiscordLegacy extends Job
	{
		private $discordUserID;
		
		public function __construct($accountDiscordID)
		{
			$this->discordUserID = $accountDiscordID;
			$this->maxAttempts = 3;
		}
		
		public function handle(): void
		{
			$discord = new Discord(
				moduleSettings('discord', 'clientID'),
				moduleSettings('discord', 'clientSecret'),
				moduleSettings('discord', 'botToken')
			);
			$discord->removeRole(
				moduleSettings('discord', 'guildID'),
				$this->discordUserID,
				moduleSettings('discord', 'syncedRoleID')
			);
			$discord->giveRole(
				moduleSettings('discord', 'guildID'),
				$this->discordUserID,
				moduleSettings('discord', 'syncedRoleID')
			);
		}
	}