<?php
	namespace Api\Libs\Rcon;
	
	use Exception;
	
	class Rcon {
		private $handler;
		
		public function __construct($host, $port, $password) {
			$gameType = ucwords(settings('gameType'), '_');
			$port = (int)$port;
			$class = "Api\\Libs\\Rcon\\Games\\" . $gameType;
			if (class_exists($class)) {
				$this->handler = new $class($host, $port, $password);
			} else {
				throw new Exception("Rcon handler for game type '$gameType' not found.");
			}
		}
		
		public function connect(): void
		{
			$this->handler->connect();
		}
		
		public function disconnect(): void
		{
			$this->handler->disconnect();
		}
		
		public function checkConnection(): bool
		{
			return $this->handler->checkConnection();
		}
		
		public function sendCommand($command, $response = false) {
			return $this->handler->sendCommand($command, $response);
		}
	}
