<?php
  namespace Api\Middlewares;
  
  use Pecee\Http\Middleware\IMiddleware;
  use Pecee\Http\Request;
  
  class TokenAuthMiddleware implements IMiddleware {
    
    public function handle(Request $request): void
    {
      if (settings('apiStatus') !== '1' || settings('apiKey') === '') {
        api()->terminateWithHttpCode(404);
      }

      if (!isset($_SERVER["HTTP_X_API_KEY"]) || $_SERVER["HTTP_X_API_KEY"] != settings('apiKey'))
        api()->unauthorized("INVALID_API_KEY", "Invalid API key!");
    }
  }