<?php
namespace Api\Services;

use PDO;

class CurrencyService
{
  public static function get($currency = null): array
  {
    if ($currency == null) $currency = settings('currency');

    $data = db()->prepare("SELECT * FROM Currencies WHERE code = ?");
    $data->execute([$currency]);
    $data = $data->fetch(PDO::FETCH_ASSOC);
    if (!$data)
      $data = [
        'code' => settings('currency'),
        'symbol' => settings('currency'),
        'rate' => 1.00,
        'autoUpdate' => 0,
        'suffix' => ' ' . settings('currency'),
        'prefix' => '',
        'label' => settings('currency'),
      ];

    return $data;
  }
}