<?php
  namespace Api\Services;

  use PDO;
  
  class ListingService
  {
    public static function buildTree($user, $categories, $products, $parent_id = 0)
    {
      $tree = array();

      foreach ($categories as $category) {
        if ($category['parentID'] == $parent_id) {
          $categoryNode = $category;

          $categoryNode["subcategories"] = self::buildTree($user, $categories, $products, $category['id']);
          $categoryNode["products"] = array();
	        
	        $subscription = null;
					if (count($products) > 0) {
						$subscription = self::getSubscriptionByCategory($user, $category);
					}

          foreach ($products as $product) {
            if ($product['categoryID'] == $category['id']) {
              $categoryNode['products'][] = self::product($product, $subscription);
            }
          }

          $tree[] = $categoryNode;
        }
      }

      return $tree;
    }
	  
	  public static function product($product, $subscription = null)
	  {
		  $discountProducts = explode(",", moduleSettings('store', 'discountProducts'));
		  $product["subsDiscountStatus"] = $subscription != null && $product["priority"] < $subscription["priority"];
		  $product["discountedPriceStatus"] = ($product["discountedPrice"] != 0 && ($product["discountExpiryDate"] > datetime() || $product["discountExpiryDate"] == '1000-01-01 00:00:00'));
		  $product["storeDiscountStatus"] = (moduleSettings('store', 'discount') != 0 && (in_array($product["id"], $discountProducts) || moduleSettings('store', 'discountProducts') == '0') && (moduleSettings('store', 'discountExpiryDate') > datetime() || moduleSettings('store', 'discountExpiryDate') == '1000-01-01 00:00:00'));
		  $product["discounted"] = $product["subsDiscountStatus"] || $product["discountedPriceStatus"] || $product["storeDiscountStatus"];
		  
		  $product["discountPercent"] = 0;
		  if ($product["discountedPriceStatus"]) {
			  $product["discountPercent"] = round((($product["price"]-$product["discountedPrice"])*100)/($product["price"]));
		  } else if ($product["storeDiscountStatus"]) {
			  $product["discountedPrice"] = ($product["price"]*(100-moduleSettings('store', 'discount')))/100;
			  $product["discountPercent"] = moduleSettings('store', 'discount');
		  }
		  
		  if ($product["subsDiscountStatus"]) {
			  if ($subscription["endsAt"] == '1000-01-01 00:00:00') {
				  $product["discountedPrice"] = ($product["discountedPriceStatus"] || $product["storeDiscountStatus"] ? $product["discountedPrice"] : $product["price"]) - ($subscription["price"]);
			  } else {
				  $product["discountedPrice"] = ($product["discountedPriceStatus"] || $product["storeDiscountStatus"] ? $product["discountedPrice"] : $product["price"]) - ((($subscription["price"]) * (strtotime($subscription["endsAt"]) - time())) / (strtotime($subscription["endsAt"]) - strtotime($subscription["startsAt"])));
			  }
			  $product["discountPercent"] = round((($product["price"]-$product["discountedPrice"])*100)/($product["price"]));
		  }
		  
		  $product["upgradable"] = $subscription != null && $product["priority"] < $subscription["priority"];
		  $product["restricted"] = $subscription != null && $product["priority"] >= $subscription["priority"];
		  
		  $product["total"] = $product["discounted"] ? $product["discountedPrice"] : $product["price"];
		  $product["subtotal"] = $product["price"] + 0;
		  $product["tax"] = (moduleSettings('store', 'tax') > 0 && moduleSettings('store', 'isCreditRequiredOnPurchase') == 0 ? ($product["total"] * moduleSettings('store', 'tax')) / 100 : 0);
		  $product["total"] += $product["tax"];
		  $product["discount"] = $product["discounted"] ? $product["price"] - $product["discountedPrice"] : 0;
		  $product["originalPrice"] = $product["price"] + (moduleSettings('store', 'tax') > 0 && moduleSettings('store', 'isCreditRequiredOnPurchase') == 0 ? ($product["price"] * moduleSettings('store', 'tax')) / 100 : 0);
		  
		  $product["image"] = "/assets/core/images/store/products/" . $product["imageID"] . "." . $product["imageType"];
			
			$currency = CurrencyService::get();
			$product["originalPriceFormatted"] = money($product["originalPrice"], $currency);
			$product["totalFormatted"] = money($product["total"], $currency);
			
		  return $product;
	  }
	  
	  public static function getSubscriptionByCategory($user, $category)
	  {
		  $discountProducts = explode(",", moduleSettings('store', 'discountProducts'));
		  $subs = null;
		  if ($category["isCumulative"] == '1' && $user) {
			  $subs = db()->prepare("SELECT * FROM Subscriptions S INNER JOIN Products P ON P.id = S.productID WHERE P.categoryID = ? AND accountID = ? AND (endsAt > ? OR endsAt = '1000-01-01 00:00:00') ORDER BY P.priority ASC LIMIT 1");
			  $subs->execute(array($category["id"], $user["id"], datetime()));
			  $subs = $subs->fetch(PDO::FETCH_ASSOC);
			  if ($subs) {
				  if ($subs["discountedPrice"] > 0 && ($subs["discountExpiryDate"] > datetime() || $subs["discountExpiryDate"] == '1000-01-01 00:00:00'))
					  $subs["price"] = $subs["discountedPrice"];
				  else if (moduleSettings('store', 'discount') != 0 && (in_array($subs["productID"], $discountProducts) || moduleSettings('store', 'discountProducts') == '0') && (moduleSettings('store', 'discountExpiryDate') > datetime() || moduleSettings('store', 'discountExpiryDate') == '1000-01-01 00:00:00'))
					  $subs["price"] = ($subs["price"] * (100 - moduleSettings('store', 'discount'))) / 100;
			  }
		  }
		  
		  return $subs;
	  }
  }