<?php
	
	namespace Api\Core;
	
	class Api
	{
		public function terminateWithHttpCode($code) {
			http_response_code($code);
			exit;
		}
		
		public function success($data = null) {
			$response = [
				"status" => true,
			];
			if ($data != null || is_array($data)) $response["data"] = $data;
			
			response()->json($response);
		}
		
		
		public function errorResponse($error = null, $message = null) {
			$response = [
				"status" => false,
			];
			if ($error != null) $response["error"] = $error;
			if ($message != null) $response["message"] = $message;
			
			response()->json($response);
		}
		
		public function error($error = null, $message = null, $responseCode = 400) {
			http_response_code($responseCode);
			self::errorResponse($error, $message);
		}
		
		public function notFound($error = 'NOT_FOUND', $message = null) {
			http_response_code(404);
			self::errorResponse($error, $message);
		}
		
		public function unauthorized($error = 'UNAUTHORIZED', $message = null) {
			http_response_code(401);
			self::errorResponse($error, $message);
		}
		
		public function badRequest($error = 'BAD_REQUEST', $message = null) {
			http_response_code(400);
			self::errorResponse($error, $message);
		}
		
		public function forbidden($error = 'FORBIDDEN', $message = null) {
			http_response_code(403);
			self::errorResponse($error, $message);
		}
		
		public function internalServerError($error = 'INTERNAL_SERVER_ERROR', $message = null) {
			http_response_code(500);
			self::errorResponse($error, $message);
		}
		
		public function notImplemented($error = 'NOT_IMPLEMENTED', $message = null) {
			http_response_code(501);
			self::errorResponse($error, $message);
		}
	}