<?php
	define("__ROOT__", $_SERVER["DOCUMENT_ROOT"]);
	const AUTO_INSTALLER_PREFIX = "auto-install";
	
	if(!session_id()) session_start();
	
	require '../vendor/autoload.php';
	
	require_once '../../main/app/config/status.php';
	if (!INSTALL_STATUS) {
		header("Location: /install");
		exit;
	}
	require_once '../../main/app/config/connect.php';
	require_once '../../main/app/config/app.php';
	require_once '../core/helper.php';
	
	try {
		$checkAutoInstallationIsCompleted = $db->prepare("SELECT * FROM Settings WHERE name = ?");
		$checkAutoInstallationIsCompleted->execute(['autoInstallation']);
		$checkAutoInstallationIsCompleted = $checkAutoInstallationIsCompleted->fetch();
		if (!$checkAutoInstallationIsCompleted) {
			die("Please contact LeaderOS Support Team! (AUTO_INSTALLATION_MISSING)");
		}
		$autoInstallationIsCompleted = $checkAutoInstallationIsCompleted["value"] == "COMPLETED";
	} catch (Exception $e) {
		die('Please contact LeaderOS Support Team! (AUTO_INSTALLATION_CHECK_FAILED)');
	}
	
	if ($autoInstallationIsCompleted) {
		header("Location: /");
		exit;
	}
	
	use AutoInstall\Handlers\CsrfExceptionHandler;
	use AutoInstall\Handlers\RouteExceptionHandler;
	use AutoInstall\Middlewares\CsrfVerifier;
	use Pecee\SimpleRouter\SimpleRouter;
	
	// Routes
	SimpleRouter::group(['exceptionHandler' => [
		RouteExceptionHandler::class,
		CsrfExceptionHandler::class
	]], function () {
		SimpleRouter::group([
			'prefix' => '/' . AUTO_INSTALLER_PREFIX,
		], function () {
			require_once '../app/config/routes.php';
		});
	});
	
	SimpleRouter::csrfVerifier(new CsrfVerifier());
	SimpleRouter::setDefaultNamespace('\AutoInstall\Controllers');
	
	try {
		SimpleRouter::start();
	} catch (Exception $e) {
		var_dump($e);
		return;
	}
