<?php
	// Check if the script is being run from the command line
	if (PHP_SAPI !== 'cli') {
		exit(1);
	}
	
	// Check if the required arguments are provided
	if (!isset($argv[1]) || !isset($argv[2])) {
		error_log('Worker: No payload provided');
		exit(1);
	}

	// Get the job name and payload from command line arguments
	$jobName = $argv[1];
	$payload = base64_decode($argv[2]);
	
	// Validate the payload
	if ($payload === false) {
		error_log('Worker: Invalid payload received');
		exit(1);
	}
	
	// Load the necessary configurations
	require_once __DIR__ . '/../main/app/config/status.php';
	require_once __DIR__ . '/../main/app/config/connect.php';
	require_once __DIR__ . '/../main/app/config/app.php';
	
	// Job name starts with Main, load the main app
	if (strpos($jobName, 'Main') === 0) {
		require_once __DIR__ . '/../main/vendor/autoload.php';
		require_once __DIR__ . '/../main/core/helper.php';

		// Initialize the worker
		$worker = new \Main\Core\Jobs\Worker();
	}

	// Job name starts with Dashboard, load the dashboard app
	if (strpos($jobName, 'Dashboard') === 0) {
		require_once __DIR__ . '/../dashboard/vendor/autoload.php';
		require_once __DIR__ . '/../dashboard/core/helper.php';
		
		// Initialize
		global $settings, $readSettings, $modules, $readModules;
		$settings = db()->query("SELECT * FROM Settings");
		foreach ($settings as $setting) {
			$readSettings[$setting["name"]] = $setting["value"];
		}
		$modules = db()->query("SELECT * FROM Modules");
		$readModules = $modules->fetchAll();
		
		// Initialize the worker
		$worker = new \Dashboard\Core\Jobs\Worker();
	}

	// Job name starts with API, load the api app
	if (strpos($jobName, 'Api') === 0) {
		require_once __DIR__ . '/../api/vendor/autoload.php';
		require_once __DIR__ . '/../api/core/helper.php';
		
		// Initialize
		global $settings, $readSettings, $modules, $readModules;
		$settings = $db->query("SELECT * FROM Settings");
		foreach ($settings as $setting) {
			$readSettings[$setting["name"]] = $setting["value"];
		}
		$modules = $db->query("SELECT * FROM Modules");
		$readModules = $modules->fetchAll();
		
		// Initialize the worker
		$worker = new \Api\Core\Jobs\Worker();
	}
	
	if (!isset($worker)) {
		error_log('Worker: Worker not initialized!');
		exit(1);
	}
	
	if (settings("timezone") != null) {
		date_default_timezone_set(settings("timezone"));
	}
	
	// Process the job
	$success = $worker->processJob($payload);
	
	exit($success ? 0 : 1);