<?php

use Dashboard\Controllers\AccountController;
use Dashboard\Controllers\AI\AiController;
use Dashboard\Controllers\AI\DataSourceController as AiDataSourceController;
use Dashboard\Controllers\AI\SettingController as AiSettingController;
use Dashboard\Controllers\Ajax\CheckController as AjaxCheckController;
use Dashboard\Controllers\Ajax\ForumCategoryController as AjaxForumCategoryController;
use Dashboard\Controllers\Ajax\SearchController as AjaxSearchController;
use Dashboard\Controllers\Ajax\TextEditorController as AjaxTextEditorController;
use Dashboard\Controllers\Ajax\MinecraftItemController as AjaxMinecraftItemController;
use Dashboard\Controllers\Ajax\OnesignalController as AjaxOnesignalController;
use Dashboard\Controllers\Ajax\StoreCategoryController as AjaxStoreCategoryController;
use Dashboard\Controllers\Ajax\ProductController as AjaxProductController;
use Dashboard\Controllers\Ajax\StatsController as AjaxStatsController;
use Dashboard\Controllers\AnnouncementController;
use Dashboard\Controllers\Appearance\ThemeAddController;
use Dashboard\Controllers\Appearance\ThemeController;
use Dashboard\Controllers\Appearance\ThemeCssController;
use Dashboard\Controllers\Appearance\ThemeEditorController;
use Dashboard\Controllers\Appearance\ThemeHeaderController;
use Dashboard\Controllers\Appearance\ThemeFooterController;
use Dashboard\Controllers\Appearance\ThemeSettingsController;
use Dashboard\Controllers\Appearance\ThemeUpdateController;
use Dashboard\Controllers\ApplicationController;
use Dashboard\Controllers\ApplicationFormController;
use Dashboard\Controllers\BanController;
use Dashboard\Controllers\Bazaar\BazaarController;
use Dashboard\Controllers\Bazaar\CustomImagesController as BazaarCustomImagesController;
use Dashboard\Controllers\Bazaar\LogController as BazaarLogController;
use Dashboard\Controllers\Blog\CategoryController as BlogCategoryController;
use Dashboard\Controllers\Blog\CommentController as BlogCommentController;
use Dashboard\Controllers\Blog\PostController as BlogPostController;
use Dashboard\Controllers\ChangelogController;
use Dashboard\Controllers\ChangelogTagController;
use Dashboard\Controllers\ChestController;
use Dashboard\Controllers\CommandLogController;
use Dashboard\Controllers\CustomFieldController;
use Dashboard\Controllers\DownloadController;
	use Dashboard\Controllers\FailedJobController;
	use Dashboard\Controllers\FormAnswerController;
use Dashboard\Controllers\FormController;
use Dashboard\Controllers\ForumCategoryController;
use Dashboard\Controllers\ForumThreadController;
use Dashboard\Controllers\GameController;
use Dashboard\Controllers\GamingNightController;
use Dashboard\Controllers\GiftController;
use Dashboard\Controllers\GiftLogController;
use Dashboard\Controllers\Help\ArticleController as HelpArticleController;
use Dashboard\Controllers\Help\TopicController as HelpTopicController;
use Dashboard\Controllers\HomeController;
use Dashboard\Controllers\LeaderboardController;
use Dashboard\Controllers\LogController;
use Dashboard\Controllers\LotteryController;
use Dashboard\Controllers\LotteryLogController;
use Dashboard\Controllers\ModuleController;
use Dashboard\Controllers\NotificationController;
use Dashboard\Controllers\PageController;
use Dashboard\Controllers\PaymentGatewayController;
use Dashboard\Controllers\PopupController;
use Dashboard\Controllers\RoleController;
use Dashboard\Controllers\ServerController;
use Dashboard\Controllers\Settings\ApiController as ApiSettingsController;
use Dashboard\Controllers\Settings\CurrencyController as CurrencySettingsController;
use Dashboard\Controllers\Settings\DiscordBotController as DiscordBotSettingsController;
use Dashboard\Controllers\Settings\DiscordBotLegacyController as DiscordBotLegacySettingsController;
use Dashboard\Controllers\Settings\GeneralController as GeneralSettingsController;
use Dashboard\Controllers\Settings\LanguageController as LanguageSettingsController;
use Dashboard\Controllers\Settings\ParasutController as ParasutSettingsController;
use Dashboard\Controllers\Settings\BirFaturaController as BirFaturaSettingsController;
use Dashboard\Controllers\Settings\PunishmentController as PunishmentSettingsController;
use Dashboard\Controllers\Settings\AccountLinkingController as AccountLinkingSettingsController;
use Dashboard\Controllers\Settings\SeoController as SeoSettingsController;
use Dashboard\Controllers\Settings\SettingController as SettingController;
use Dashboard\Controllers\Settings\SmtpController as SmtpSettingsController;
use Dashboard\Controllers\Settings\EmailTemplateController as EmailTemplateSettingsController;
use Dashboard\Controllers\Settings\SystemController as SystemSettingsController;
use Dashboard\Controllers\Settings\BazaarController as BazaarSettingsController;
use Dashboard\Controllers\Settings\BlogController as BlogSettingsController;
use Dashboard\Controllers\Settings\StoreController as StoreSettingsController;
use Dashboard\Controllers\Settings\CreditController as CreditSettingsController;
use Dashboard\Controllers\Settings\SupportController as SupportSettingsController;
use Dashboard\Controllers\Settings\VoteController as VoteSettingsController;
use Dashboard\Controllers\Settings\ChestController as ChestSettingsController;
use Dashboard\Controllers\Settings\TawktoController as TawktoSettingsController;
use Dashboard\Controllers\Settings\GoogleAnalyticsController as GoogleAnalyticsSettingsController;
use Dashboard\Controllers\Settings\RecaptchaController as RecaptchaSettingsController;
use Dashboard\Controllers\Store\CreatorCodeController as StoreCreatorCodeController;
use Dashboard\Controllers\Store\CreatorCodeLogController as StoreCreatorCodeLogController;
use Dashboard\Controllers\Store\VariableController as StoreVariableController;
use Dashboard\Controllers\TebexStore\SettingController as TebexStoreSettingsController;
use Dashboard\Controllers\Settings\DiscordWebhookController;
use Dashboard\Controllers\SliderController;
use Dashboard\Controllers\StatsController;
use Dashboard\Controllers\Store\BulkDiscountController as StoreBulkDiscountController;
use Dashboard\Controllers\Store\CategoryController as StoreCategoryController;
use Dashboard\Controllers\Store\ChestLogController as StoreChestLogController;
use Dashboard\Controllers\Store\ChestSendController as StoreChestSendController;
use Dashboard\Controllers\Store\CommunityGoalController;
use Dashboard\Controllers\Store\CouponController as StoreCouponController;
use Dashboard\Controllers\Store\CouponLogController as StoreCouponLogController;
use Dashboard\Controllers\Store\CreditPackageController as StoreCreditPackageController;
use Dashboard\Controllers\Store\CreditPurchaseLogController as StoreCreditPurchaseLogController;
use Dashboard\Controllers\Store\CreditSendController as StoreCreditSendController;
use Dashboard\Controllers\Store\CreditUsageLogController as StoreCreditUsageLogController;
use Dashboard\Controllers\Store\PaymentController as StorePaymentController;
use Dashboard\Controllers\Store\OrderController as StoreOrderController;
use Dashboard\Controllers\Store\ProductController as StoreProductController;
use Dashboard\Controllers\SuggestionCategoryController;
use Dashboard\Controllers\SuggestionController;
use Dashboard\Controllers\Support\CategoryController as SupportCategoryController;
use Dashboard\Controllers\Support\MessageController as SupportMessageController;
use Dashboard\Controllers\Support\QuickAnswerController as SupportQuickAnswerController;
use Dashboard\Controllers\Support\TicketController as SupportTicketController;
use Dashboard\Controllers\UpdateController;
use Dashboard\Controllers\UrlRedirectController;
use Dashboard\Controllers\VipTableController;
use Dashboard\Controllers\VoteController;
use Dashboard\Controllers\Bazaar\ServerController as BazaarServerController;
use Pecee\SimpleRouter\SimpleRouter as Router;

Router::get('/', [HomeController::class,'index'])->name('dashboard.home');
Router::get('/stats', [StatsController::class,'index'])->name('dashboard.stats.index');

Router::get('/accounts/staff', [AccountController::class, 'staff'])->name('dashboard.accounts.staff');
Router::post('/accounts/{id}/unlinkDiscord', [AccountController::class, 'unlinkDiscord'])->name('dashboard.accounts.unlinkDiscord');
Router::post('/accounts/{id}/unlinkAccount/{provider}', [AccountController::class, 'unlinkAccount'])->name('dashboard.accounts.unlinkAccount');
Router::post('/accounts/{id}/removeTfa', [AccountController::class, 'removeTfa'])->name('dashboard.accounts.removeTfa');
Router::post('/accounts/{id}/uploadAvatar', [AccountController::class, 'uploadAvatar'])->name('dashboard.accounts.uploadAvatar');
Router::post('/accounts/{id}/removeAvatar', [AccountController::class, 'removeAvatar'])->name('dashboard.accounts.removeAvatar');
Router::resource('/accounts', AccountController::class)->name('dashboard.accounts');

Router::resource('/announcements', AnnouncementController::class)->name('dashboard.announcements');

Router::resource('/applications/forms', ApplicationFormController::class)->name('dashboard.applications.forms');
Router::get('/applications', [ApplicationController::class, 'index'])->name('dashboard.applications.index');
Router::get('/applications/{id}', [ApplicationController::class, 'show'])->name('dashboard.applications.show');
Router::post('/applications/{id}/reject', [ApplicationController::class, 'reject'])->name('dashboard.applications.reject');
Router::post('/applications/{id}/approve', [ApplicationController::class, 'approve'])->name('dashboard.applications.approve');
Router::delete('/applications/{id}', [ApplicationController::class, 'destroy'])->name('dashboard.applications.destroy');

Router::resource('/bans', BanController::class)->name('dashboard.bans');

Router::get('/bazaar/logs', [BazaarLogController::class, 'index'])->name('dashboard.bazaar.logs.index');
Router::delete('/bazaar/logs/{id}', [BazaarLogController::class, 'destroy'])->name('dashboard.bazaar.logs.destroy');

Router::resource('/bazaar/custom-item-images', BazaarCustomImagesController::class)->name('dashboard.bazaar.custom-item-images');
Router::resource('/bazaar/servers', BazaarServerController::class)->name('dashboard.bazaar.servers');

Router::get('/bazaar', [BazaarController::class, 'index'])->name('dashboard.bazaar.index');
Router::get('/bazaar/{id}/edit', [BazaarController::class, 'edit'])->name('dashboard.bazaar.edit');
Router::patch('/bazaar/{id}', [BazaarController::class, 'update'])->name('dashboard.bazaar.update');
Router::delete('/bazaar/{id}', [BazaarController::class, 'destroy'])->name('dashboard.bazaar.destroy');

Router::delete('/chests/{id}', [ChestController::class, 'destroy'])->name('dashboard.chests.destroy');
Router::resource('/custom-fields', CustomFieldController::class)->name('dashboard.custom-fields');
Router::resource('/downloads', DownloadController::class)->name('dashboard.downloads');

Router::get('/forms/answers', [FormAnswerController::class, 'index'])->name('dashboard.forms.answers.index');
Router::get('/forms/answers/{id}', [FormAnswerController::class, 'show'])->name('dashboard.forms.answers.show');
Router::delete('/forms/answers/{id}', [FormAnswerController::class, 'destroy'])->name('dashboard.forms.answers.destroy');
Router::resource('/forms', FormController::class)->name('dashboard.forms');

Router::resource('/forum/categories', ForumCategoryController::class)->name('dashboard.forum.categories');
Router::get('/forum/threads', [ForumThreadController::class, 'index'])->name('dashboard.forum.threads.index');
Router::delete('/forum/threads/{id}', [ForumThreadController::class, 'destroy'])->name('dashboard.forum.threads.destroy');

Router::resource('/games', GameController::class)->name('dashboard.games');
Router::get('/gaming-night', [GamingNightController::class, 'index'])->name('dashboard.gaming-night.index');
Router::patch('/gaming-night', [GamingNightController::class, 'update'])->name('dashboard.gaming-night.update');

Router::get('/gifts/logs', [GiftLogController::class, 'index'])->name('dashboard.gifts.logs.index');
Router::get('/gifts/logs/{id}', [GiftLogController::class, 'show'])->name('dashboard.gifts.logs.show');
Router::delete('/gifts/logs/{id}', [GiftLogController::class, 'destroy'])->name('dashboard.gifts.logs.destroy');
Router::resource('/gifts', GiftController::class)->name('dashboard.gifts');

Router::resource('/help/topics', HelpTopicController::class)->name('dashboard.help.topics');
Router::resource('/help/articles', HelpArticleController::class)->name('dashboard.help.articles');

Router::resource('/leaderboards', LeaderboardController::class)->name('dashboard.leaderboards');

Router::get('/logs', [LogController::class, 'index'])->name('dashboard.logs.index');
Router::delete('/logs/delete-all', [LogController::class, 'destroyAll'])->name('dashboard.logs.destroyAll');
Router::delete('/logs/{id}', [LogController::class, 'destroy'])->name('dashboard.logs.destroy');

Router::get('/failed-jobs', [FailedJobController::class, 'index'])->name('dashboard.failed-jobs.index');
Router::post('/failed-jobs/{id}/retry', [FailedJobController::class, 'retry'])->name('dashboard.failed-jobs.retry');
Router::delete('/failed-jobs/delete-all', [FailedJobController::class, 'destroyAll'])->name('dashboard.failed-jobs.destroyAll');
Router::delete('/failed-jobs/{id}', [FailedJobController::class, 'destroy'])->name('dashboard.failed-jobs.destroy');

Router::get('/lotteries/logs', [LotteryLogController::class, 'index'])->name('dashboard.lotteries.logs.index');
Router::get('/lotteries/logs/{id}', [LotteryLogController::class, 'show'])->name('dashboard.lotteries.logs.show');
Router::delete('/lotteries/logs/{id}', [LotteryLogController::class, 'destroy'])->name('dashboard.lotteries.logs.destroy');
Router::resource('/lotteries', LotteryController::class)->name('dashboard.lotteries');

Router::post('/modules/toggle/{id}', [ModuleController::class, 'toggle'])->name('dashboard.modules.toggle');
Router::get('/modules', [ModuleController::class, 'index'])->name('dashboard.modules.index');

Router::get('/blog/comments', [BlogCommentController::class, 'index'])->name('dashboard.blog.comments.index');
Router::get('/blog/comments/{id}/edit', [BlogCommentController::class, 'edit'])->name('dashboard.blog.comments.edit');
Router::patch('/blog/comments/{id}', [BlogCommentController::class, 'update'])->name('dashboard.blog.comments.update');
Router::delete('/blog/comments/{id}', [BlogCommentController::class, 'destroy'])->name('dashboard.blog.comments.destroy');
Router::resource('/blog/categories', BlogCategoryController::class)->name('dashboard.blog.categories');
Router::resource('/blog/posts', BlogPostController::class)->name('dashboard.blog.posts');

Router::get('/notifications', [NotificationController::class, 'index'])->name('dashboard.notifications.index');
Router::resource('/pages', PageController::class)->name('dashboard.pages');
Router::resource('/redirects', UrlRedirectController::class)->name('dashboard.redirects');
Router::get('/payment-gateways', [PaymentGatewayController::class, 'index'])->name('dashboard.payment-gateways.index');
Router::get('/payment-gateways/{id}/edit', [PaymentGatewayController::class, 'edit'])->name('dashboard.payment-gateways.edit');
Router::patch('/payment-methods/{id}', [PaymentGatewayController::class, 'update'])->name('dashboard.payment-gateways.update');
Router::resource('/roles', RoleController::class)->name('dashboard.roles');

Router::post('/servers/{id}/reset-token', [ServerController::class, 'resetConsoleToken'])->name('dashboard.servers.resetConsoleToken');
Router::get('/servers/{id}/plugin', [ServerController::class, 'plugin'])->name('dashboard.servers.plugin');
Router::resource('/servers', ServerController::class)->name('dashboard.servers');

Router::get('/popup/edit', [PopupController::class, 'edit'])->name('dashboard.popup.edit');
Router::patch('/popup', [PopupController::class, 'update'])->name('dashboard.popup.update');

Router::resource('/changelog', ChangelogController::class)->name('dashboard.changelog');
Router::resource('/changelog-tags', ChangelogTagController::class)->name('dashboard.changelog.tags');

Router::group([
	'prefix' => '/tebex-store'
], function () {
	Router::get('/settings', [TebexStoreSettingsController::class, 'index'])->name('dashboard.tebex-store.settings.index');
	Router::patch('/settings', [TebexStoreSettingsController::class, 'update'])->name('dashboard.tebex-store.settings.update');
});

Router::resource('/discord-webhooks', DiscordWebhookController::class)->name('dashboard.discord-webhooks');

Router::group([
    'prefix' => '/settings'
], function () {
    Router::get('/', [SettingController::class, 'index'])->name('dashboard.settings.index');
    Router::get('/general', [GeneralSettingsController::class, 'index'])->name('dashboard.settings.general.index');
    Router::patch('/general', [GeneralSettingsController::class, 'update'])->name('dashboard.settings.general.update');
    Router::get('/system', [SystemSettingsController::class, 'index'])->name('dashboard.settings.system.index');
    Router::patch('/system', [SystemSettingsController::class, 'update'])->name('dashboard.settings.system.update');
    Router::get('/smtp', [SmtpSettingsController::class, 'index'])->name('dashboard.settings.smtp.index');
    Router::patch('/smtp', [SmtpSettingsController::class, 'update'])->name('dashboard.settings.smtp.update');
		Router::get('/email-templates', [EmailTemplateSettingsController::class, 'index'])->name('dashboard.settings.email-templates.index');
		Router::patch('/email-templates/{id}', [EmailTemplateSettingsController::class, 'update'])->name('dashboard.settings.email-templates.update');
    Router::get('/seo', [SeoSettingsController::class, 'index'])->name('dashboard.settings.seo.index');
    Router::patch('/seo/{id}', [SeoSettingsController::class, 'update'])->name('dashboard.settings.seo.update');
    Router::patch('/languages/{id}/set', [LanguageSettingsController::class, 'set'])->name('dashboard.settings.languages.set');
    Router::post('/languages/{id}/toggle', [LanguageSettingsController::class, 'toggle'])->name('dashboard.settings.languages.toggle');
    Router::resource('/languages', LanguageSettingsController::class)->name('dashboard.settings.languages');
    Router::get('/currencies', [CurrencySettingsController::class, 'index'])->name('dashboard.settings.currencies.index');
    Router::patch('/currencies/{id}/set', [CurrencySettingsController::class, 'set'])->name('dashboard.settings.currencies.set');
    Router::post('/currencies/{id}/toggle', [CurrencySettingsController::class, 'toggle'])->name('dashboard.settings.currencies.toggle');
    Router::get('/currencies/{id}/edit', [CurrencySettingsController::class, 'edit'])->name('dashboard.settings.currencies.edit');
    Router::patch('/currencies/{id}', [CurrencySettingsController::class, 'update'])->name('dashboard.settings.currencies.update');
    Router::delete('/currencies/{id}', [CurrencySettingsController::class, 'destroy'])->name('dashboard.settings.currencies.destroy');
    Router::get('/discord-bot-legacy', [DiscordBotLegacySettingsController::class, 'index'])->name('dashboard.settings.discord-bot-legacy.index');
    Router::patch('/discord-bot-legacy', [DiscordBotLegacySettingsController::class, 'update'])->name('dashboard.settings.discord-bot-legacy.update');
    Router::get('/discord-bot', [DiscordBotSettingsController::class, 'index'])->name('dashboard.settings.discord-bot.index');
    Router::patch('/discord-bot', [DiscordBotSettingsController::class, 'update'])->name('dashboard.settings.discord-bot.update');
    Router::get('/discord-bot/link', [DiscordBotSettingsController::class, 'link'])->name('dashboard.settings.discord-bot.link');
    Router::post('/discord-bot/validate', [DiscordBotSettingsController::class, 'validate'])->name('dashboard.settings.discord-bot.validate');
    Router::post('/discord-bot/reset', [DiscordBotSettingsController::class, 'reset'])->name('dashboard.settings.discord-bot.reset');
    Router::post('/discord-bot/link-roles', [DiscordBotSettingsController::class, 'linkRoles'])->name('dashboard.settings.discord-bot.linkRoles');
    Router::get('/punishments', [PunishmentSettingsController::class, 'index'])->name('dashboard.settings.punishments.index');
    Router::patch('/punishments', [PunishmentSettingsController::class, 'update'])->name('dashboard.settings.punishments.update');
    Router::get('/api', [ApiSettingsController::class, 'index'])->name('dashboard.settings.api.index');
    Router::match(['get', 'post'], '/api/regenerate-api-key', [ApiSettingsController::class, 'regenerateApiKey'])->name('dashboard.settings.api.regenerateApiKey');
    Router::post('/api/toggle', [ApiSettingsController::class, 'toggle'])->name('dashboard.settings.api.toggle');
    Router::get('/parasut', [ParasutSettingsController::class, 'index'])->name('dashboard.settings.parasut.index');
    Router::patch('/parasut', [ParasutSettingsController::class, 'update'])->name('dashboard.settings.parasut.update');
    Router::get('/parasut/oauth', [ParasutSettingsController::class, 'oauth'])->name('dashboard.settings.parasut.oauth');
    Router::get('/birfatura', [BirFaturaSettingsController::class, 'index'])->name('dashboard.settings.birfatura.index');
    Router::patch('/birfatura', [BirFaturaSettingsController::class, 'update'])->name('dashboard.settings.birfatura.update');
    Router::get('/account-linking', [AccountLinkingSettingsController::class, 'index'])->name('dashboard.settings.account-linking.index');
    Router::post('/account-linking/toggle-provider/{id}', [AccountLinkingSettingsController::class, 'toggleProvider'])->name('dashboard.settings.account-linking.toggleProvider');
		Router::get('/bazaar', [BazaarSettingsController::class, 'index'])->name('dashboard.settings.bazaar.index');
		Router::patch('/bazaar', [BazaarSettingsController::class, 'update'])->name('dashboard.settings.bazaar.update');
		Router::get('/blog', [BlogSettingsController::class, 'index'])->name('dashboard.settings.blog.index');
		Router::patch('/blog', [BlogSettingsController::class, 'update'])->name('dashboard.settings.blog.update');
		Router::get('/store', [StoreSettingsController::class, 'index'])->name('dashboard.settings.store.index');
		Router::patch('/store', [StoreSettingsController::class, 'update'])->name('dashboard.settings.store.update');
		Router::get('/support', [SupportSettingsController::class, 'index'])->name('dashboard.settings.support.index');
		Router::patch('/support', [SupportSettingsController::class, 'update'])->name('dashboard.settings.support.update');
		Router::get('/credit', [CreditSettingsController::class, 'index'])->name('dashboard.settings.credit.index');
		Router::patch('/credit', [CreditSettingsController::class, 'update'])->name('dashboard.settings.credit.update');
		Router::get('/chest', [ChestSettingsController::class, 'index'])->name('dashboard.settings.chest.index');
		Router::patch('/chest', [ChestSettingsController::class, 'update'])->name('dashboard.settings.chest.update');
		Router::get('/vote', [VoteSettingsController::class, 'index'])->name('dashboard.settings.vote.index');
		Router::patch('/vote', [VoteSettingsController::class, 'update'])->name('dashboard.settings.vote.update');
		Router::get('/tawkto', [TawktoSettingsController::class, 'index'])->name('dashboard.settings.tawkto.index');
		Router::patch('/tawkto', [TawktoSettingsController::class, 'update'])->name('dashboard.settings.tawkto.update');
		Router::get('/google-analytics', [GoogleAnalyticsSettingsController::class, 'index'])->name('dashboard.settings.google-analytics.index');
		Router::patch('/google-analytics', [GoogleAnalyticsSettingsController::class, 'update'])->name('dashboard.settings.google-analytics.update');
		Router::get('/recaptcha', [RecaptchaSettingsController::class, 'index'])->name('dashboard.settings.recaptcha.index');
		Router::patch('/recaptcha', [RecaptchaSettingsController::class, 'update'])->name('dashboard.settings.recaptcha.update');
});
Router::resource('/sliders', SliderController::class)->name('dashboard.sliders');
Router::group([
    'prefix' => '/store'
], function () {
    Router::get('/credit/send', [StoreCreditSendController::class, 'index'])->name('dashboard.store.credit.send.index');
    Router::post('/credit/send', [StoreCreditSendController::class, 'send'])->name('dashboard.store.credit.send.send');
    Router::get('/chest/send', [StoreChestSendController::class, 'index'])->name('dashboard.store.chest.send.index');
    Router::post('/chest/send', [StoreChestSendController::class, 'send'])->name('dashboard.store.chest.send.send');
    Router::get('/bulk-discount', [StoreBulkDiscountController::class, 'index'])->name('dashboard.store.bulk-discount.index');
    Router::patch('/bulk-discount', [StoreBulkDiscountController::class, 'update'])->name('dashboard.store.bulk-discount.update');
    Router::get('/chest-logs', [StoreChestLogController::class, 'index'])->name('dashboard.store.chest-logs.index');
    Router::get('/chest-logs/{id}', [StoreChestLogController::class, 'show'])->name('dashboard.store.chest-logs.show');
    Router::delete('/chest-logs/{id}', [StoreChestLogController::class, 'destroy'])->name('dashboard.store.chest-logs.destroy');
    Router::get('/coupon-logs', [StoreCouponLogController::class, 'index'])->name('dashboard.store.coupon-logs.index');
    Router::delete('/coupon-logs/{id}', [StoreCouponLogController::class, 'destroy'])->name('dashboard.store.coupon-logs.destroy');
    Router::get('/credit-purchase-logs', [StoreCreditPurchaseLogController::class, 'index'])->name('dashboard.store.credit-purchase-logs.index');
    Router::delete('/credit-purchase-logs/{id}', [StoreCreditPurchaseLogController::class, 'destroy'])->name('dashboard.store.credit-purchase-logs.destroy');
    Router::get('/credit-usage-logs', [StoreCreditUsageLogController::class, 'index'])->name('dashboard.store.credit-usage-logs.index');
    Router::delete('/credit-usage-logs/{id}', [StoreCreditUsageLogController::class, 'destroy'])->name('dashboard.store.credit-usage-logs.destroy');
		Router::get('/creator-code-logs', [StoreCreatorCodeLogController::class, 'index'])->name('dashboard.store.creator-code-logs.index');
		Router::delete('/creator-code-logs/{id}', [StoreCreatorCodeLogController::class, 'destroy'])->name('dashboard.store.creator-code-logs.destroy');
    Router::get('/payments', [StorePaymentController::class, 'index'])->name('dashboard.store.payments.index');
    Router::get('/orders', [StoreOrderController::class, 'index'])->name('dashboard.store.orders.index');
    Router::get('/orders/create', [StoreOrderController::class, 'create'])->name('dashboard.store.orders.create');
    Router::post('/orders/create', [StoreOrderController::class, 'store'])->name('dashboard.store.orders.store');
    Router::post('/orders/{id}/complete', [StoreOrderController::class, 'complete'])->name('dashboard.store.orders.complete');
    Router::get('/orders/{id}', [StoreOrderController::class, 'show'])->name('dashboard.store.orders.show');
    Router::delete('/orders/{id}', [StoreOrderController::class, 'destroy'])->name('dashboard.store.orders.destroy');
    Router::get('/community-goals', [CommunityGoalController::class, 'index'])->name('dashboard.store.community-goals.index');
    Router::patch('/community-goals', [CommunityGoalController::class, 'update'])->name('dashboard.store.community-goals.update');

    Router::get('/products/table', [StoreProductController::class, 'tableView'])->name('dashboard.store.products.tableView');
    Router::post('/products/order', [StoreProductController::class, 'order'])->name('dashboard.store.products.order');
    Router::get('/products/{id}/create', [StoreProductController::class, 'clone'])->name('dashboard.store.products.clone');
    Router::resource('/products', StoreProductController::class)->name('dashboard.store.products');
    Router::resource('/categories', StoreCategoryController::class)->name('dashboard.store.categories');
    Router::resource('/credit-packages', StoreCreditPackageController::class)->name('dashboard.store.credit-packages');
    Router::resource('/coupons', StoreCouponController::class)->name('dashboard.store.coupons');
    Router::resource('/variables', StoreVariableController::class)->name('dashboard.store.variables');
		Router::resource('/creator-codes', StoreCreatorCodeController::class)->name('dashboard.store.creator-codes');
});
Router::post('/command-logs/send', [CommandLogController::class, 'sendAll'])->name('dashboard.command-logs.sendAll');
Router::post('/command-logs/send/{id}', [CommandLogController::class, 'send'])->name('dashboard.command-logs.send');
Router::resource('/suggestions/categories', SuggestionCategoryController::class)->name('dashboard.suggestions.categories');
Router::resource('/suggestions', SuggestionController::class)->name('dashboard.suggestions');
Router::group([
    'prefix' => '/support'
], function () {
    Router::get('/tickets', [SupportTicketController::class, 'index'])->name('dashboard.support.tickets.index');
    Router::delete('/tickets/delete-selected', [SupportTicketController::class, 'destroySelected'])->name('dashboard.support.tickets.destroySelected');
    Router::post('/tickets/{id}/messages', [SupportMessageController::class, 'store'])->name('dashboard.support.tickets.messages.store');
    Router::delete('/tickets/{id}/messages', [SupportMessageController::class, 'destroy'])->name('dashboard.support.tickets.messages.destroy');
    Router::patch('/tickets/{id}/close', [SupportTicketController::class, 'close'])->name('dashboard.support.tickets.close');
    Router::get('/tickets/{id}', [SupportTicketController::class, 'show'])->name('dashboard.support.tickets.show');
    Router::delete('/tickets/{id}', [SupportTicketController::class, 'destroy'])->name('dashboard.support.tickets.destroy');
    Router::resource('/categories', SupportCategoryController::class)->name('dashboard.support.categories');
    Router::resource('/quick-answers', SupportQuickAnswerController::class)->name('dashboard.support.quick-answers');
});
Router::group([
    'prefix' => '/appearance'
], function () {
    Router::get('/themes', [ThemeController::class, 'index'])->name('dashboard.appearance.themes.index');
    Router::post('/themes/install', [ThemeController::class, 'install'])->name('dashboard.appearance.themes.install');
    Router::post('/themes/set', [ThemeController::class, 'set'])->name('dashboard.appearance.themes.set');
    Router::get('/themes/add', [ThemeAddController::class, 'index'])->name('dashboard.appearance.themes.add.index');
    Router::post('/themes/add', [ThemeAddController::class, 'add'])->name('dashboard.appearance.themes.add.add');
    Router::get('/themes/settings', [ThemeSettingsController::class, 'index'])->name('dashboard.appearance.themes.settings.index');
    Router::patch('/themes/settings', [ThemeSettingsController::class, 'update'])->name('dashboard.appearance.themes.settings.update');
    Router::get('/themes/update', [ThemeUpdateController::class, 'index'])->name('dashboard.appearance.themes.update.index');
    Router::post('/themes/update', [ThemeUpdateController::class, 'update'])->name('dashboard.appearance.themes.update.update');
    Router::get('/header', [ThemeHeaderController::class, 'index'])->name('dashboard.appearance.header.index');
    Router::patch('/header', [ThemeHeaderController::class, 'update'])->name('dashboard.appearance.header.update');
		Router::get('/footer', [ThemeFooterController::class, 'index'])->name('dashboard.appearance.footer.index');
		Router::patch('/footer', [ThemeFooterController::class, 'update'])->name('dashboard.appearance.footer.update');
    Router::get('/css', [ThemeCssController::class, 'index'])->name('dashboard.appearance.css.index');
    Router::patch('/css', [ThemeCssController::class, 'update'])->name('dashboard.appearance.css.update');
    Router::all('/editor', [ThemeEditorController::class, 'index'])->name('dashboard.appearance.editor.index');
});
Router::get('/updates', [UpdateController::class, 'index'])->name('dashboard.updates.index');
Router::post('/updates', [UpdateController::class, 'update'])->name('dashboard.updates.update');
Router::get('/updates/check', [UpdateController::class, 'check'])->name('dashboard.updates.check');

Router::resource('/vip-tables', VipTableController::class)->name('dashboard.vip-tables');

Router::resource('/votes', VoteController::class)->name('dashboard.votes');

Router::get('/ai', [AiController::class, 'index'])->name('dashboard.ai.index');
Router::get('/ai/settings', [AiSettingController::class, 'index'])->name('dashboard.ai.settings.index');
Router::patch('/ai/settings', [AiSettingController::class, 'update'])->name('dashboard.ai.settings.update');
Router::get('/ai/data', [AiDataSourceController::class, 'index'])->name('dashboard.ai.data.index');
Router::post('/ai/data', [AiDataSourceController::class, 'process'])->name('dashboard.ai.data.process');
Router::delete('/ai/data/{id}', [AiDataSourceController::class, 'destroy'])->name('dashboard.ai.data.destroy');
Router::post('/ai/generate-with-ai', [AiController::class, 'generateWithAi'])->name('dashboard.ai.generateWithAi');

Router::group([
    'prefix' => '/ajax'
], function () {
    Router::get('/search', [AjaxSearchController::class, 'index'])->name('dashboard.ajax.search');
    Router::get('/search-user', [AjaxSearchController::class, 'user'])->name('dashboard.ajax.search-user');
		
    Router::post('/check/console', [AjaxCheckController::class, 'console'])->name('dashboard.ajax.check.console');
    Router::post('/check/mysql', [AjaxCheckController::class, 'mysql'])->name('dashboard.ajax.check.mysql');
    Router::post('/check/smtp', [AjaxCheckController::class, 'smtp'])->name('dashboard.ajax.check.smtp');
    Router::post('/check/webhook', [AjaxCheckController::class, 'webhook'])->name('dashboard.ajax.check.webhook');

    Router::get('/store/products/tree', [AjaxProductController::class, 'tree'])->name('dashboard.ajax.products.tree');
    Router::get('/store/products/jstree', [AjaxProductController::class, 'jstree'])->name('dashboard.ajax.store.products.jstree');
    Router::get('/store/products/getByCategory', [AjaxProductController::class, 'getByCategory'])->name('dashboard.ajax.products.getByCategory');

    Router::get('/store/categories', [AjaxStoreCategoryController::class, 'index'])->name('dashboard.ajax.store.categories');

    Router::get('/forum/categories', [AjaxForumCategoryController::class, 'index'])->name('dashboard.ajax.forum.categories');
    Router::get('/minecraft-items', [AjaxMinecraftItemController::class, 'index'])->name('dashboard.ajax.minecraft-items');
    Router::get('/stats', [AjaxStatsController::class, 'index'])->name('dashboard.ajax.stats');

    Router::post('/editor/upload', [AjaxTextEditorController::class, 'upload'])->name('dashboard.ajax.editor.upload');
    Router::post('/onesignal', [AjaxOnesignalController::class, 'index'])->name('dashboard.ajax.onesignal');
});