<?php

namespace Dashboard\Controllers\Ajax;

use Dashboard\Core\Controller;

class MinecraftItemController extends Controller
{
    public function index()
    {
        $data = file_get_contents('items.json', FILE_USE_INCLUDE_PATH);
        $data = json_decode($data, true);
        $categories = [];

        if (get("disableDefault") && get("disableDefault") != "true") {
          $categories[] = [
                'item' => 'default',
                'name' => t__('Default')
            ];
        }
        foreach ($data as $readData) {
          $categories[] = [
              'item' => $readData["item"],
              'name' => $readData["name"],
              'icon' => $readData["item"],
            ];
        }

        response()->json($categories);
    }
}