<?php

namespace Dashboard\Controllers\Ajax;

use Curl\Curl;
use Dashboard\Core\Controller;
use Dashboard\Services\ProductService;
use PDO;

class ProductController extends Controller
{
    public function tree() {
      $categories = db()->query("SELECT id, name, parentID FROM ProductCategories ORDER BY priority DESC");
      $categories = $categories->fetchAll(PDO::FETCH_ASSOC);

      $products = db()->query("SELECT id, name, categoryID FROM Products ORDER BY priority DESC");
      $products = $products->fetchAll(PDO::FETCH_ASSOC);

      response()->json([
        'categories' => ProductService::buildTree($categories, $products)
      ]);
    }

    public function getByCategory() {
      abort_perm('MANAGE_STORE');

      if (moduleIsDisabled('tebex_store')) {
	      $products = db()->prepare("SELECT id, name FROM Products WHERE categoryID = ? ORDER BY priority DESC");
	      $products->execute(array(get("categoryID")));
	      $products = $products->fetchAll(PDO::FETCH_ASSOC);
      } else {
				$createBasket = new Curl();
	      $createBasket->post('https://headless.tebex.io/api/accounts/'. moduleSettings('tebex_store', 'publicKey') .'/baskets', [
	        'username' => auth()->user()->displayName(),
		      //'ip_address' => getIP(),
	      ]);
				$basketID = $createBasket->response->data->ident;
				$categoryRequest = new Curl();
	      $categoryRequest->get('https://headless.tebex.io/api/accounts/' . moduleSettings('tebex_store', 'publicKey') . '/categories/' . get("categoryID") . '?includePackages=1&basketIdent=' . $basketID);
				if ($categoryRequest->error) {
					response()->json([]);
				}
				$products = $categoryRequest->response->data->packages;
      }

      response()->json($products);
    }

  public function jstree()
  {
    abort_perm('MANAGE_STORE') || abort_perm('MANAGE_GIFTS');

    $treeArray = [];
	  $categories = db()->query("SELECT * FROM ProductCategories WHERE parentID = 0 OR parentID IN (SELECT id FROM ProductCategories) ORDER BY priority DESC");
    foreach ($categories as $category) {
      $treeArray[] = array(
        "id" => "c_" . $category["id"],
        "parent" => $category["parentID"] == 0 ? "#" : "c_" . $category["parentID"],
        "text" => $category["name"],
        "type" => "category"
      );

      $products = db()->prepare("SELECT * FROM Products WHERE categoryID = ? ORDER BY priority DESC");
      $products->execute(array($category["id"]));
      foreach ($products as $product) {
        $treeArray[] = array(
          "id" => $product["id"],
          "parent" => "c_" . $category["id"],
          "text" => $product["name"],
          "type" => "product"
        );
      }
    }

    response()->json($treeArray);
  }
}