<?php

namespace Dashboard\Controllers\Ajax;

use Dashboard\Core\Controller;
use PDO;

class StatsController extends Controller
{
    public function index()
    {
        function limitParam($key, $default = 5)
        {
            if (get($key)) {
                if (!is_numeric(get($key))) {
                    $_GET[$key] = 1;
                }
                return intval(get($key));
            }
            return 5;
        }

        if (get("target") == 'check') {
            if (get("action") == 'website-url') {
              if (auth()->user()->can('MANAGE_SETTINGS')) {
                $websiteURL = ((!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://") . $_SERVER['HTTP_HOST'];
                if ($websiteURL != settings('websiteURL') && isset($_SERVER["HTTP_HOST"]) && $_SERVER["HTTP_HOST"] != "" && $_SERVER["HTTP_HOST"] != null) {
                  updateSetting("websiteURL", $websiteURL);
                  response()->json([
                    'status' => true,
                    'url' => $websiteURL
                  ]);
                } else {
                  response()->json([
                    'status' => false
                  ]);
                }
              } else {
                response()->json([
                  'status' => false
                ]);
              }
            }
            if (get("action") == 'account-cache') {
                if (auth()->user()->can('MANAGE_ACCOUNTS')) {
                    if (createDuration(-1) > settings("lastCheckAccounts")) {
                        $totalAccountCount = db()->query("SELECT count(id) FROM Accounts");
                        $totalAccountCount = $totalAccountCount->fetchColumn();

                        $thisYearAccountCount = db()->prepare("SELECT count(id) FROM Accounts WHERE creationDate LIKE ?");
                        $thisYearAccountCount->execute(array("%" . date("Y") . "%"));
                        $thisYearAccountCount = $thisYearAccountCount->fetchColumn();

                        $thisMonthAccountCount = db()->prepare("SELECT count(id) FROM Accounts WHERE creationDate LIKE ?");
                        $thisMonthAccountCount->execute(array("%" . date("Y-m") . "%"));
                        $thisMonthAccountCount = $thisMonthAccountCount->fetchColumn();

                        $lastMonthAccountCount = db()->prepare("SELECT count(id) FROM Accounts WHERE creationDate LIKE ?");
                        $lastMonthAccountCount->execute(array("%" . date("Y-m", strtotime("first day of last month")) . "%"));
                        $lastMonthAccountCount = $lastMonthAccountCount->fetchColumn();

                        updateSettings([
                            'lastCheckAccounts' => datetime(),
                            'totalAccountCount' => $totalAccountCount,
                            'thisYearAccountCount' => $thisYearAccountCount,
                            'thisMonthAccountCount' => $thisMonthAccountCount,
                            'lastMonthAccountCount' => $lastMonthAccountCount
                        ]);

                        response()->json([
                            'status' => true
                        ]);
                    } else {
                        response()->json([
                            'status' => false
                        ]);
                    }
                } else {
                    response()->json([
                        'status' => false
                    ]);
                }
            }
            if (get("action") == 'currency-cache') {
                if (auth()->user()->can('MANAGE_SETTINGS')) {
                    if (createDuration(-1) > settings("lastCheckCurrencies")) {
                        $currencies = db()->query("SELECT * FROM Currencies");
                        $currencies = $currencies->fetchAll(PDO::FETCH_ASSOC);
                        $data = checkCurrency(settings("currency"));
                        if (empty($data["rates"])) {
                          response()->json([
                            'status' => false
                          ]);
                        }

                        foreach ($currencies as $currency) {
                            if (!isset($data["rates"][$currency["code"]]) || $data["rates"][$currency["code"]] == 0)
                                continue;

                            if ($currency["autoUpdate"] == 0)
                                continue;

                            $updateCurrency = db()->prepare("UPDATE Currencies SET rate = ? WHERE code = ?");
                            $updateCurrency->execute(array($data["rates"][$currency["code"]], $currency["code"]));
                        }
                        updateSetting("lastCheckCurrencies", datetime());

                        response()->json([
                            'status' => true
                        ]);
                    } else {
                        response()->json([
                            'status' => false
                        ]);
                    }
                } else {
                    response()->json([
                        'status' => false
                    ]);
                }
            } else {
                response()->json([
                    'status' => false
                ]);
            }
        } else if (get("target") == 'chart') {
            if (get("action") == 'user') {
                if (auth()->user()->can('MANAGE_ACCOUNTS')) {
                    // DATA
                    $registeredUsers = db()->prepare("SELECT DATE_FORMAT(creationDate, '%Y-%m') AS creationMonth, COUNT(id) AS total FROM Accounts WHERE YEAR(creationDate) = YEAR(CURRENT_DATE) GROUP BY YEAR(creationDate), MONTH(creationDate) ORDER BY creationDate ASC");
                    $registeredUsers->execute();
                    $registeredUsers = $registeredUsers->fetchAll(PDO::FETCH_ASSOC);
                    for ($i = 1, $yearRegisteredUsersData = []; $i <= 12; $i++) {
                        $date = sprintf("%d-%02d", date('Y'), $i);
                        $total = 0;
                        foreach ($registeredUsers as $registeredUser) {
                            if ($registeredUser["creationMonth"] == $date) {
                                $total = $registeredUser["total"];
                                break;
                            }
                        }
                        $yearRegisteredUsersData[] = $total;
                    }

                    // VALUE
                    $thisYearAccountCount = settings("thisYearAccountCount");

                    $jsonData = json_encode(array(
                        'yearRegisteredUsersData' => $yearRegisteredUsersData,
                        'yearRegisteredUsersValue' => convertNumber($thisYearAccountCount)
                    ));
                    return $jsonData;
                } else {
                    $jsonData = json_encode(array(
                        'yearRegisteredUsersData' => [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                        'yearRegisteredUsersValue' => 0
                    ));
                    return $jsonData;
                }
            } else if (get("action") == 'earn') {
                if (auth()->user()->can('SUPER_ADMIN')) {
                    // DATA
		                $earnedMoney = db()->prepare("SELECT DATE_FORMAT(creationDate, '%Y-%m') AS creationMonth, SUM(earnings) AS earnings FROM Orders WHERE status = ? AND YEAR(creationDate) = YEAR(CURRENT_DATE) GROUP BY YEAR(creationDate), MONTH(creationDate) ORDER BY creationDate ASC");
		                $earnedMoney->execute(array(1));
                    $readEarnedMoney = $earnedMoney->fetchAll(PDO::FETCH_ASSOC);
                    for ($i = 1, $yearEarnedMoneyData = []; $i <= 12; $i++) {
                        $date = sprintf("%d-%02d", date('Y'), $i);
                        $total = 0;
                        foreach ($readEarnedMoney as $earnedMoney) {
		                        if ($earnedMoney["creationMonth"] == $date) {
                                $total = $earnedMoney["earnings"];
                                break;
                            }
                        }
                        $yearEarnedMoneyData[] = $total;
                    }

                    // VALUE
		                $yearEarnedMoney = 0;
		                foreach ($yearEarnedMoneyData as $yearEarnedMoneyValue) {
				                $yearEarnedMoney += $yearEarnedMoneyValue;
		                }

                    $jsonData = json_encode(array(
                        'yearEarnedMoneyData' => $yearEarnedMoneyData,
                        'yearEarnedMoneyValue' => number_format($yearEarnedMoney, 0, ',', '.')
                    ));
                    return $jsonData;
                } else {
                    $jsonData = json_encode(array(
                        'yearEarnedMoneyData' => [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                        'yearEarnedMoneyValue' => 0
                    ));
                    return $jsonData;
                }
            } else {
                response()->json([
                    'status' => false
                ]);
            }
        } else if (get("target") == 'card') {
            if (get("action") == 'user') {
                $totalAccountCount = settings("totalAccountCount");
                $thisYearAccountCount = settings("thisYearAccountCount");
                $thisMonthAccountCount = settings("thisMonthAccountCount");
                $lastMonthAccountCount = settings("lastMonthAccountCount");

                $jsonData = json_encode(array(
                    'totalAccountCount' => $totalAccountCount,
                    'thisYearAccountCount' => $thisYearAccountCount,
                    'thisMonthAccountCount' => $thisMonthAccountCount,
                    'lastMonthAccountCount' => $lastMonthAccountCount
                ));
                return $jsonData;
            } else if (get("action") == 'this-month-earn') {
                if (auth()->user()->can('SUPER_ADMIN')) {
                    $thisMonthEarnedMoney = db()->prepare("SELECT SUM(earnings) AS earnings FROM Orders WHERE status = ? AND creationDate LIKE ?");
                    $thisMonthEarnedMoney->execute(array(1, "%" . date("Y-m") . "%"));
                    $readThisMonthEarnedMoney = $thisMonthEarnedMoney->fetch();
                    if ($readThisMonthEarnedMoney["earnings"] == null) {
                        $readThisMonthEarnedMoney["earnings"] = 0;
                    }

                    $lastMonthEarnedMoney = db()->prepare("SELECT SUM(earnings) AS earnings FROM Orders WHERE status = ? AND creationDate LIKE ?");
                    $lastMonthEarnedMoney->execute(array(1, "%" . date("Y-m", strtotime("first day of last month")) . "%"));
                    $readLastMonthEarnedMoney = $lastMonthEarnedMoney->fetch();
                    if ($readLastMonthEarnedMoney["earnings"] == null) {
                        $readLastMonthEarnedMoney["earnings"] = 0;
                    }
                    $jsonData = json_encode(array(
                        'thisMonthEarnedMoney' => $readThisMonthEarnedMoney["earnings"],
                        'lastMonthEarnedMoney' => $readLastMonthEarnedMoney["earnings"]
                    ));
                    return $jsonData;
                } else {
                    $jsonData = json_encode(array(
                        'thisMonthEarnedMoney' => 0,
                        'lastMonthEarnedMoney' => 0
                    ));
                    return $jsonData;
                }
            } else if (get("action") == 'today-earn') {
                if (auth()->user()->can('SUPER_ADMIN')) {
                    $todayEarnedMoney = db()->prepare("SELECT SUM(earnings) AS earnings FROM Orders WHERE status = ? AND creationDate LIKE ?");
                    $todayEarnedMoney->execute(array(1, "%" . date("Y-m-d") . "%"));
                    $readTodayEarnedMoney = $todayEarnedMoney->fetch();
                    if ($readTodayEarnedMoney["earnings"] == null) {
                        $readTodayEarnedMoney["earnings"] = 0;
                    }

                    $yesterdayEarnedMoney = db()->prepare("SELECT SUM(earnings) AS earnings FROM Orders WHERE status = ? AND creationDate LIKE ?");
                    $yesterdayEarnedMoney->execute(array(1, "%" . date("Y-m-d", strtotime("-1 day")) . "%"));
                    $readYesterdayEarnedMoney = $yesterdayEarnedMoney->fetch();
                    if ($readYesterdayEarnedMoney["earnings"] == null) {
                        $readYesterdayEarnedMoney["earnings"] = 0;
                    }
                    $jsonData = json_encode(array(
                        'todayEarnedMoney' => $readTodayEarnedMoney["earnings"],
                        'yesterdayEarnedMoney' => $readYesterdayEarnedMoney["earnings"]
                    ));
                    return $jsonData;
                } else {
                    $jsonData = json_encode(array(
                        'todayEarnedMoney' => 0,
                        'yesterdayEarnedMoney' => 0
                    ));
                    return $jsonData;
                }
            } else if (get("action") == 'waiting-comments') {
                if (auth()->user()->can('MANAGE_BLOG')) {
                    $unconfirmedComments = db()->prepare("SELECT count(NC.id) FROM NewsComments NC INNER JOIN Accounts A ON NC.accountID = A.id INNER JOIN News N ON NC.newsID = N.id WHERE NC.status = ?");
                    $unconfirmedComments->execute(array(0));
                    $jsonData = json_encode(array(
                        'rowCount' => $unconfirmedComments->fetchColumn()
                    ));
                    return $jsonData;
                } else {
                    $jsonData = json_encode(array(
                        'rowCount' => 0
                    ));
                    return $jsonData;
                }
            } else if (get("action") == 'this-month-blog-posts') {
                if (auth()->user()->can('MANAGE_BLOG')) {
                    $writedNews = db()->prepare("SELECT count(N.id) FROM News N INNER JOIN Accounts A ON N.accountID = A.id INNER JOIN NewsCategories NC ON N.categoryID = NC.id WHERE N.creationDate LIKE ?");
                    $writedNews->execute(array("%" . date("Y-m") . "%"));
                    $jsonData = json_encode(array(
                        'rowCount' => $writedNews->fetchColumn()
                    ));
                    return $jsonData;
                } else {
                    $jsonData = json_encode(array(
                        'rowCount' => 0
                    ));
                    return $jsonData;
                }
            } else if (get("action") == 'this-month-support-tickets') {
                if (auth()->user()->can('MANAGE_SUPPORT') || auth()->user()->can('MANAGE_SUPPORT_TICKETS')) {
                    $supportMessages = db()->prepare("SELECT count(S.id) FROM Supports S INNER JOIN SupportCategories SC ON S.categoryID = SC.id INNER JOIN Accounts A ON S.accountID = A.id WHERE S.creationDate LIKE ?");
                    $supportMessages->execute(array("%" . date("Y-m") . "%"));
                    $jsonData = json_encode(array(
                        'rowCount' => $supportMessages->fetchColumn()
                    ));
                    return $jsonData;
                } else {
                    $jsonData = json_encode(array(
                        'rowCount' => 0
                    ));
                    return $jsonData;
                }
            } else if (get("action") == 'waiting-support-tickets') {
                $unreadSupportMessages = db()->prepare("SELECT count(S.id) FROM Supports S INNER JOIN SupportCategories SC ON S.categoryID = SC.id INNER JOIN Accounts A ON S.accountID = A.id WHERE S.statusID IN (?, ?)");
                $unreadSupportMessages->execute(array(1, 3));
                $jsonData = json_encode(array(
                    'rowCount' => $unreadSupportMessages->fetchColumn()
                ));
                return $jsonData;
            } else {
                response()->json([
                    'status' => false
                ]);
            }
        } else if (get("target") == "stats") {
            if (auth()->user()->can('VIEW_STATS')) {
                if (get("type") == "overview") {
                    if (get("get") == 'all_time_sales') {
                        $orders = db()->prepare("SELECT SUM(earnings) FROM Orders WHERE status = ?");
                        $orders->execute(array(1));
                        $orderEarnings = $orders->fetchColumn();
                        if ($orderEarnings == null)
                            $orderEarnings = 0;
                        response()->json([
                            'sales' => money($orderEarnings)
                        ]);
                    }
                    if (get("get") == 'year_to_date_sales') {
                        $orders = db()->prepare("SELECT SUM(earnings) FROM Orders WHERE status = ? AND creationDate LIKE ?");
                        $orders->execute(array(1, date("Y") . "%"));
                        $orderEarnings = $orders->fetchColumn();
                        if ($orderEarnings == null)
                            $orderEarnings = 0;
                        response()->json([
                            'sales' => money($orderEarnings)
                        ]);
                    }
                    if (get("get") == 'month_to_date_sales') {
                        $orders = db()->prepare("SELECT SUM(earnings) FROM Orders WHERE status = ? AND creationDate LIKE ?");
                        $orders->execute(array(1, date("Y-m") . "%"));
                        $orderEarnings = $orders->fetchColumn();
                        if ($orderEarnings == null)
                            $orderEarnings = 0;
                        response()->json([
                            'sales' => money($orderEarnings)
                        ]);
                    }
                    if (get("get") == 'today_sales') {
                        $orders = db()->prepare("SELECT SUM(earnings) FROM Orders WHERE status = ? AND creationDate LIKE ?");
                        $orders->execute(array(1, date("Y-m-d") . "%"));
                        $orderEarnings = $orders->fetchColumn();
                        if ($orderEarnings == null)
                            $orderEarnings = 0;
                        response()->json([
                            'sales' => money($orderEarnings)
                        ]);
                    }

                    if (get("get") == 'all_time_tickets') {
                        $tickets = db()->query("SELECT COUNT(id) FROM Supports");
                        $tickets = $tickets->fetchColumn();
                        if ($tickets == null)
                            $tickets = 0;
                        response()->json([
                            'tickets' => $tickets
                        ]);
                    }
                    if (get("get") == 'month_to_date_tickets') {
                        $tickets = db()->prepare("SELECT COUNT(id) FROM Supports WHERE creationDate LIKE ?");
                        $tickets->execute(array(date("Y-m") . "%"));
                        $tickets = $tickets->fetchColumn();
                        if ($tickets == null)
                            $tickets = 0;
                        response()->json([
                            'tickets' => $tickets
                        ]);
                    }
                    if (get("get") == 'closed_tickets') {
                        $tickets = db()->prepare("SELECT COUNT(id) FROM Supports WHERE statusID = ?");
                        $tickets->execute(array(4));
                        $tickets = $tickets->fetchColumn();
                        if ($tickets == null)
                            $tickets = 0;
                        response()->json([
                            'tickets' => $tickets
                        ]);
                    }
                    if (get("get") == 'waiting_reply_tickets') {
                        $tickets = db()->prepare("SELECT COUNT(id) FROM Supports WHERE statusID IN (?, ?)");
                        $tickets->execute(array(1, 3));
                        $tickets = $tickets->fetchColumn();
                        if ($tickets == null)
                            $tickets = 0;
                        response()->json([
                            'tickets' => $tickets
                        ]);
                    }

                    if (get("get") == 'all_time_registrations') {
                        $registrations = db()->query("SELECT COUNT(id) FROM Accounts");
                        $registrations = $registrations->fetchColumn();
                        if ($registrations == null)
                            $registrations = 0;
                        response()->json([
                            'registrations' => $registrations
                        ]);
                    }
                    if (get("get") == 'year_to_date_registrations') {
                        $registrations = db()->prepare("SELECT COUNT(id) FROM Accounts WHERE creationDate LIKE ?");
                        $registrations->execute(array(date("Y") . "%"));
                        $registrations = $registrations->fetchColumn();
                        if ($registrations == null)
                            $registrations = 0;
                        response()->json([
                            'registrations' => $registrations
                        ]);
                    }
                    if (get("get") == 'month_to_date_registrations') {
                        $registrations = db()->prepare("SELECT COUNT(id) FROM Accounts WHERE creationDate LIKE ?");
                        $registrations->execute(array(date("Y-m") . "%"));
                        $registrations = $registrations->fetchColumn();
                        if ($registrations == null)
                            $registrations = 0;
                        response()->json([
                            'registrations' => $registrations
                        ]);
                    }
                    if (get("get") == 'today_registrations') {
                        $registrations = db()->prepare("SELECT COUNT(id) FROM Accounts WHERE creationDate LIKE ?");
                        $registrations->execute(array(date("Y-m-d") . "%"));
                        $registrations = $registrations->fetchColumn();
                        if ($registrations == null)
                            $registrations = 0;
                        response()->json([
                            'registrations' => $registrations
                        ]);
                    }
										if (get("get") == "popular_categories" && get("from") && get("to")) {
												$from = date('Y-m-d 00:00:00', strtotime(get("from")));
												$to = date('Y-m-d 23:59:59', strtotime(get("to")));
											
												$orders = db()->prepare("SELECT C.id, C.name as category, SUM(OP.quantity) AS quantity, SUM(OP.unitPrice * OP.quantity) as total FROM Orders O INNER JOIN OrderProducts OP ON OP.orderID = O.id INNER JOIN Products P ON P.id = OP.productID INNER JOIN ProductCategories C ON C.id = P.categoryID WHERE O.status = ? AND O.creationDate >= ? AND O.creationDate <= ? GROUP BY C.id ORDER BY total DESC LIMIT 5");
												$orders->execute([1, $from, $to]);
												$readOrders = array_map(function ($order) {
													$order["total"] = money($order["total"]);
													return $order;
												}, $orders->fetchAll(PDO::FETCH_ASSOC));
												if ($orders->rowCount() > 0) {
													response()->json($readOrders);
												} else {
													response()->json([]);
												}
										}
		                if (get("get") == "popular_products" && get("from") && get("to")) {
			                $from = date('Y-m-d 00:00:00', strtotime(get("from")));
			                $to = date('Y-m-d 23:59:59', strtotime(get("to")));
			                
			                $orders = db()->prepare("SELECT P.id, P.name as product, SUM(OP.quantity) AS quantity, SUM(OP.unitPrice * OP.quantity) as total FROM Orders O INNER JOIN OrderProducts OP ON OP.orderID = O.id INNER JOIN Products P ON P.id = OP.productID WHERE O.status = ? AND O.creationDate >= ? AND O.creationDate <= ? GROUP BY P.id ORDER BY total DESC LIMIT 5");
			                $orders->execute([1, $from, $to]);
			                $readOrders = array_map(function ($order) {
				                $order["total"] = money($order["total"]);
				                return $order;
			                }, $orders->fetchAll(PDO::FETCH_ASSOC));
			                if ($orders->rowCount() > 0) {
				                response()->json($readOrders);
			                } else {
				                response()->json([]);
			                }
		                }
                }
                if (get("type") == "monthly_report") {
                    $data = [];
                    $date = date('Y-m-01');

                    $from = date('Y-m-01 00:00:00');
                    $to = date('Y-m-d 23:59:59');

                    $orders = db()->prepare("SELECT creationDate, SUM(earnings) as earnings FROM Orders WHERE status = ? AND creationDate >= ? AND creationDate <= ? GROUP BY DAY(creationDate) ORDER BY creationDate ASC");
                    $orders->execute(array(1, $from, $to));
                    $orders = $orders->fetchAll(PDO::FETCH_ASSOC);

                    $registrations = db()->prepare("SELECT creationDate, COUNT(id) as total FROM Accounts WHERE creationDate >= ? AND creationDate <= ? GROUP BY DAY(creationDate) ORDER BY creationDate ASC");
                    $registrations->execute(array($from, $to));
                    $registrations = $registrations->fetchAll(PDO::FETCH_ASSOC);

                    $forumThreads = db()->prepare("SELECT creationDate, COUNT(id) as total FROM ForumThreads WHERE creationDate >= ? AND creationDate <= ? GROUP BY DAY(creationDate) ORDER BY creationDate ASC");
                    $forumThreads->execute(array($from, $to));
                    $forumThreads = $forumThreads->fetchAll(PDO::FETCH_ASSOC);

                    $forumReplies = db()->prepare("SELECT creationDate, COUNT(id) as total FROM ForumReplies WHERE creationDate >= ? AND creationDate <= ? GROUP BY DAY(creationDate) ORDER BY creationDate ASC");
                    $forumReplies->execute(array($from, $to));
                    $forumReplies = $forumReplies->fetchAll(PDO::FETCH_ASSOC);

                    $supportTickets = db()->prepare("SELECT creationDate, COUNT(id) as total FROM Supports WHERE creationDate >= ? AND creationDate <= ? GROUP BY DAY(creationDate) ORDER BY creationDate ASC");
                    $supportTickets->execute(array($from, $to));
                    $supportTickets = $supportTickets->fetchAll(PDO::FETCH_ASSOC);

                    while (strtotime($date) <= strtotime(date('Y-m-d'))) {
                        $orderEarnings = 0;
                        $registrationsCount = 0;
                        $forumThreadsCount = 0;
                        $forumRepliesCount = 0;
                        $supportTicketsCount = 0;

                        foreach ($orders as $order) {
                            if (date("Y-m-d", strtotime($order['creationDate'])) == $date) {
                                $orderEarnings = $order['earnings'];
                                break;
                            }
                        }
                        foreach ($registrations as $registration) {
                            if (date("Y-m-d", strtotime($registration['creationDate'])) == $date) {
                                $registrationsCount = $registration['total'];
                                break;
                            }
                        }
                        foreach ($forumThreads as $thread) {
                            if (date("Y-m-d", strtotime($thread['creationDate'])) == $date) {
                                $forumThreadsCount = $thread['total'];
                                break;
                            }
                        }
                        foreach ($forumReplies as $reply) {
                            if (date("Y-m-d", strtotime($reply['creationDate'])) == $date) {
                                $forumRepliesCount = $reply['total'];
                                break;
                            }
                        }
                        foreach ($supportTickets as $ticket) {
                            if (date("Y-m-d", strtotime($ticket['creationDate'])) == $date) {
                                $supportTicketsCount = $ticket['total'];
                                break;
                            }
                        }
                        $data[] = array(
                            'date' => $date,
                            'earnings' => money($orderEarnings),
                            'registrations' => $registrationsCount,
                            'forumThreads' => $forumThreadsCount,
                            'forumReplies' => $forumRepliesCount,
                            'supportTickets' => $supportTicketsCount,
                        );
                        $date = date("Y-m-d", strtotime("+1 day", strtotime($date)));
                    }
                    response()->json($data);
                }
                if (get("type") == "payments" && get("from") && get("to")) {
                    $from = date('Y-m-d 00:00:00', strtotime(get("from")));
                    $to = date('Y-m-d 23:59:59', strtotime(get("to")));
                    if (get("get") == "total_revenue") {
                        $orders = db()->prepare("SELECT SUM(earnings) FROM Orders WHERE status = ? AND creationDate >= ? AND creationDate <= ?");
                        $orders->execute(array(1, $from, $to));
                        $orders = $orders->fetchColumn();
                        if ($orders == null)
                            $orders = 0;
                        response()->json([
                            'total' => money($orders)
                        ]);
                    }
                    if (get("get") == "avg_daily_revenue") {
                        $orders = db()->prepare("SELECT SUM(earnings) FROM Orders WHERE status = ? AND creationDate >= ? AND creationDate <= ?");
                        $orders->execute(array(1, $from, $to));
                        $orders = $orders->fetchColumn();
                        if ($orders == null)
                            $orders = 0;
                        $day = ceil((strtotime($to) - strtotime($from)) / (60 * 60 * 24));
                        response()->json([
                            'total' => money($orders / $day)
                        ]);
                    }
                    if (get("get") == "popular_payment_gateway") {
                        $orders = db()->prepare("SELECT P.name as paymentGateway, COUNT(O.id) as total FROM Orders O INNER JOIN PaymentGateways P ON P.slug = O.paymentAPI WHERE O.status = ? AND O.creationDate >= ? AND O.creationDate <= ? GROUP BY O.paymentAPI ORDER BY total DESC LIMIT 1");
                        $orders->execute(array(1, $from, $to));
                        $readOrders = $orders->fetch();
                        if ($orders->rowCount() > 0) {
                            response()->json([
                                'paymentGateway' => $readOrders["paymentGateway"]
                            ]);
                        } else {
                            response()->json([
                                'paymentGateway' => '-'
                            ]);
                        }
                    }
                    if (get("get") == "chart" && get("interval")) {
                        $labels = [];
                        $data = [];
                        $date = $from;
                        if (get("interval") == "daily") {
                            $orders = db()->prepare("SELECT creationDate, SUM(earnings) as earnings FROM Orders WHERE status = ? AND creationDate >= ? AND creationDate <= ? GROUP BY DAY(creationDate) ORDER BY creationDate ASC");
                            $orders->execute(array(1, $from, $to));
                            $orders = $orders->fetchAll(PDO::FETCH_ASSOC);

                            while (strtotime($date) <= strtotime($to)) {
                                $labels[] = date("d M y", strtotime($date));

                                $earnings = 0;
                                foreach ($orders as $order) {
                                    if (date("Y-m-d", strtotime($order['creationDate'])) == date("Y-m-d", strtotime($date))) {
                                        $earnings = $order['earnings'];
                                        break;
                                    }
                                }
                                $data[] = $earnings;

                                $date = date("Y-m-d", strtotime("+1 day", strtotime($date)));
                            }
                        }
                        if (get("interval") == "weekly") {
                            $from = date('Y-m-d 00:00:00', strtotime('this week', strtotime($from)));
                            $to = date('Y-m-d 23:59:00', strtotime('this sunday', strtotime($to)));

                            $orders = db()->prepare("SELECT FROM_DAYS(TO_DAYS(creationDate) -MOD(TO_DAYS(creationDate) -2, 7)) AS creationDate, SUM(earnings) as earnings FROM Orders WHERE status = ? AND creationDate >= ? AND creationDate <= ? GROUP BY WEEK(creationDate, 1) ORDER BY creationDate ASC");
                            $orders->execute(array(1, $from, $to));
                            $orders = $orders->fetchAll(PDO::FETCH_ASSOC);

                            $date = $from;
                            while (strtotime($date) <= strtotime($to)) {
                                $labels[] = date("d M y", strtotime($date));
                                $earnings = 0;
                                foreach ($orders as $order) {
                                    if (date("Y-m-d", strtotime($order['creationDate'])) == date("Y-m-d", strtotime($date))) {
                                        $earnings = $order['earnings'];
                                        break;
                                    }
                                }
                                $data[] = $earnings;

                                $date = date("Y-m-d", strtotime("+1 week", strtotime($date)));
                            }
                        }
                        response()->json([
                            'labels' => $labels,
                            'data' => $data
                        ]);
                    }
                }
		            if (get("type") == "categories" && get("category") && get("from") && get("to")) {
			            $from = date('Y-m-d 00:00:00', strtotime(get("from")));
			            $to = date('Y-m-d 23:59:59', strtotime(get("to")));
									$category = get("category");
									
									// Find sub categories
			            $categoryList = self::getSubcategoryIds($category);
			            $categoryList[] = $category;
			            $questionMarks = str_repeat('?,', count($categoryList) - 1) . '?';
									
			            if (get("get") == "total_revenue") {
				            $orders = db()->prepare("SELECT SUM(OP.unitPrice * OP.quantity) FROM Orders O INNER JOIN OrderProducts OP ON OP.orderID = O.id INNER JOIN Products P ON P.id = OP.productID WHERE O.status = ? AND O.creationDate >= ? AND O.creationDate <= ? AND P.categoryID IN ($questionMarks)");
				            $orders->execute(array_merge([1, $from, $to], $categoryList));
				            $orders = $orders->fetchColumn();
				            if ($orders == null)
					            $orders = 0;
				            response()->json([
					            'total' => money($orders)
				            ]);
			            }
			            if (get("get") == "total_purchases") {
				            $orders = db()->prepare("SELECT SUM(OP.quantity) FROM Orders O INNER JOIN OrderProducts OP ON OP.orderID = O.id INNER JOIN Products P ON P.id = OP.productID WHERE O.status = ? AND O.creationDate >= ? AND O.creationDate <= ? AND P.categoryID IN ($questionMarks)");
				            $orders->execute(array_merge([1, $from, $to], $categoryList));
				            $orders = $orders->fetchColumn();
				            if ($orders == null)
					            $orders = 0;
				            response()->json([
					            'total' => $orders
				            ]);
			            }
			            if (get("get") == "popular_products") {
				            $orders = db()->prepare("SELECT P.id, P.name as product, SUM(OP.quantity) AS quantity, SUM(OP.unitPrice * OP.quantity) as total FROM Orders O INNER JOIN OrderProducts OP ON OP.orderID = O.id INNER JOIN Products P ON P.id = OP.productID WHERE O.status = ? AND O.creationDate >= ? AND O.creationDate <= ? AND P.categoryID IN ($questionMarks) GROUP BY P.id ORDER BY total DESC LIMIT 5");
				            $orders->execute(array_merge([1, $from, $to], $categoryList));
				            $readOrders = array_map(function ($order) {
					            $order["total"] = money($order["total"]);
					            return $order;
				            }, $orders->fetchAll(PDO::FETCH_ASSOC));
				            if ($orders->rowCount() > 0) {
					            response()->json($readOrders);
				            } else {
					            response()->json([]);
				            }
			            }
			            if (get("get") == "chart" && get("interval")) {
				            $labels = [];
				            $data = [];
				            $date = $from;
				            if (get("interval") == "daily") {
					            $orders = db()->prepare("SELECT O.creationDate, SUM(OP.unitPrice * OP.quantity) as earnings FROM Orders O INNER JOIN OrderProducts OP ON OP.orderID = O.id INNER JOIN Products P ON P.id = OP.productID WHERE O.status = ? AND O.creationDate >= ? AND O.creationDate <= ? AND P.categoryID IN ($questionMarks) GROUP BY DAY(O.creationDate) ORDER BY O.creationDate ASC");
					            $orders->execute(array_merge([1, $from, $to], $categoryList));
					            $orders = $orders->fetchAll(PDO::FETCH_ASSOC);
					            
					            while (strtotime($date) <= strtotime($to)) {
						            $labels[] = date("d M y", strtotime($date));
						            
						            $earnings = 0;
						            foreach ($orders as $order) {
							            if (date("Y-m-d", strtotime($order['creationDate'])) == date("Y-m-d", strtotime($date))) {
								            $earnings = $order['earnings'];
								            break;
							            }
						            }
						            $data[] = $earnings;
						            
						            $date = date("Y-m-d", strtotime("+1 day", strtotime($date)));
					            }
				            }
				            if (get("interval") == "weekly") {
					            $from = date('Y-m-d 00:00:00', strtotime('this week', strtotime($from)));
					            $to = date('Y-m-d 23:59:00', strtotime('this sunday', strtotime($to)));
					            
					            $orders = db()->prepare("SELECT FROM_DAYS(TO_DAYS(O.creationDate) -MOD(TO_DAYS(O.creationDate) -2, 7)) AS creationDate, SUM(OP.unitPrice * OP.quantity) as earnings FROM Orders O INNER JOIN OrderProducts OP ON OP.orderID = O.id INNER JOIN Products P ON P.id = OP.productID WHERE O.status = ? AND O.creationDate >= ? AND O.creationDate <= ? AND P.categoryID IN ($questionMarks) GROUP BY WEEK(O.creationDate, 1) ORDER BY O.creationDate ASC");
					            $orders->execute(array_merge([1, $from, $to], $categoryList));
					            $orders = $orders->fetchAll(PDO::FETCH_ASSOC);
					            
					            $date = $from;
					            while (strtotime($date) <= strtotime($to)) {
						            $labels[] = date("d M y", strtotime($date));
						            $earnings = 0;
						            foreach ($orders as $order) {
							            if (date("Y-m-d", strtotime($order['creationDate'])) == date("Y-m-d", strtotime($date))) {
								            $earnings = $order['earnings'];
								            break;
							            }
						            }
						            $data[] = $earnings;
						            
						            $date = date("Y-m-d", strtotime("+1 week", strtotime($date)));
					            }
				            }
				            response()->json([
					            'labels' => $labels,
					            'data' => $data
				            ]);
			            }
		            }
                if (get("type") == "donors") {
                    if (get("get") == "all_time") {
                        $topDonor = db()->prepare("SELECT A.id as userID, A.username, A.realname, SUM(O.earnings) as total FROM Orders O INNER JOIN Accounts A ON A.id = O.accountID WHERE O.status = ? GROUP BY O.accountID ORDER BY total DESC LIMIT 1");
                        $topDonor->execute(array(1));
                        $readTopDonor = $topDonor->fetch();
                        if ($topDonor->rowCount() == 0) {
                            response()->json([
	                              'userID' => '-',
                                'username' => '-',
																'displayName' => '-',
                                'total' => money(0)
                            ]);
                        } else {
                            response()->json([
	                              'userID' => $readTopDonor["userID"],
                                'username' => $readTopDonor["username"],
	                              'displayName' => $readTopDonor["realname"],
                                'total' => money($readTopDonor["total"]),
                            ]);
                        }
                    }
                    if (get("get") == "all_time_list") {
                        $limit = limitParam("limit");
                        $topDonorList = db()->prepare("SELECT A.id as userID, A.username, A.realname as displayName, SUM(O.earnings) as total FROM Orders O INNER JOIN Accounts A ON A.id = O.accountID WHERE O.status = ? GROUP BY O.accountID ORDER BY total DESC LIMIT $limit");
                        $topDonorList->execute(array(1));
                        $topDonorList = $topDonorList->fetchAll(PDO::FETCH_ASSOC);
                        for ($i = 0; $i < count($topDonorList); $i++) {
                            $topDonorList[$i]["id"] = $i + 1;
                            $topDonorList[$i]["total"] = money($topDonorList[$i]["total"]);
                        }
                        response()->json($topDonorList);
                    }
                    if (get("get") == "annually") {
                        $topDonor = db()->prepare("SELECT A.id as userID, A.username, A.realname, SUM(O.earnings) as total FROM Orders O INNER JOIN Accounts A ON A.id = O.accountID WHERE O.status = ? AND O.creationDate LIKE ? GROUP BY O.accountID ORDER BY total DESC LIMIT 1");
                        $topDonor->execute(array(1, date("Y") . "%"));
                        $readTopDonor = $topDonor->fetch();
                        if ($topDonor->rowCount() == 0) {
                            response()->json([
	                              'userID' => '-',
                                'username' => '-',
	                              'displayName' => '-',
                                'total' => money(0)
                            ]);
                        } else {
                            response()->json([
	                              'userID' => $readTopDonor["userID"],
                                'username' => $readTopDonor["username"],
	                              'displayName' => $readTopDonor["realname"],
                                'total' => money($readTopDonor["total"]),
                            ]);
                        }
                    }
                    if (get("get") == "annually_list") {
                        $limit = limitParam("limit");
                        $topDonorList = db()->prepare("SELECT A.id as userID, A.username, A.realname as displayName, SUM(O.earnings) as total FROM Orders O INNER JOIN Accounts A ON A.id = O.accountID WHERE O.status = ? AND O.creationDate LIKE ? GROUP BY O.accountID ORDER BY total DESC LIMIT $limit");
                        $topDonorList->execute(array(1, date("Y") . "%"));
                        $topDonorList = $topDonorList->fetchAll(PDO::FETCH_ASSOC);
                        for ($i = 0; $i < count($topDonorList); $i++) {
                            $topDonorList[$i]["id"] = $i + 1;
                            $topDonorList[$i]["total"] = money($topDonorList[$i]["total"]);
                        }
                        response()->json($topDonorList);
                    }
                    if (get("get") == "monthly") {
                        $topDonor = db()->prepare("SELECT A.id as userID, A.username, A.realname, SUM(O.earnings) as total FROM Orders O INNER JOIN Accounts A ON A.id = O.accountID WHERE O.status = ? AND O.creationDate LIKE ? GROUP BY O.accountID ORDER BY total DESC LIMIT 1");
                        $topDonor->execute(array(1, date("Y-m") . "%"));
                        $readTopDonor = $topDonor->fetch();
                        if ($topDonor->rowCount() == 0) {
                            response()->json([
	                              'userID' => '-',
                                'username' => '-',
	                              'displayName' => '-',
                                'total' => money(0)
                            ]);
                        } else {
                            response()->json([
	                              'userID' => $readTopDonor["userID"],
                                'username' => $readTopDonor["username"],
                                'displayName' => $readTopDonor["realname"],
                                'total' => money($readTopDonor["total"]),
                            ]);
                        }
                    }
                    if (get("get") == "monthly_list") {
                        $limit = limitParam("limit");
                        $topDonorList = db()->prepare("SELECT A.id as userID, A.username, A.realname as displayName, SUM(O.earnings) as total FROM Orders O INNER JOIN Accounts A ON A.id = O.accountID WHERE O.status = ? AND O.creationDate LIKE ? GROUP BY O.accountID ORDER BY total DESC LIMIT $limit");
                        $topDonorList->execute(array(1, date("Y-m") . "%"));
                        $topDonorList = $topDonorList->fetchAll(PDO::FETCH_ASSOC);
                        for ($i = 0; $i < count($topDonorList); $i++) {
                            $topDonorList[$i]["id"] = $i + 1;
                            $topDonorList[$i]["total"] = money($topDonorList[$i]["total"]);
                        }
                        response()->json($topDonorList);
                    }
                    if (get("get") == "today") {
                        $topDonor = db()->prepare("SELECT A.id as userID, A.username, A.realname, SUM(O.earnings) as total FROM Orders O INNER JOIN Accounts A ON A.id = O.accountID WHERE O.status = ? AND O.creationDate LIKE ? GROUP BY O.accountID ORDER BY total DESC LIMIT 1");
                        $topDonor->execute(array(1, date("Y-m-d") . "%"));
                        $readTopDonor = $topDonor->fetch();
                        if ($topDonor->rowCount() == 0) {
                            response()->json([
                                'userID' => '-',
                                'username' => '-',
	                              'displayName' => '-',
                                'total' => money(0)
                            ]);
                        } else {
                            response()->json([
	                              'userID' => $readTopDonor["userID"],
                                'username' => $readTopDonor["username"],
	                              'displayName' => $readTopDonor["realname"],
                                'total' => money($readTopDonor["total"]),
                            ]);
                        }
                    }
                    if (get("get") == "today_list") {
                        $limit = limitParam("limit");
                        $topDonorList = db()->prepare("SELECT A.id as userID, A.username, A.realname as displayName, SUM(O.earnings) as total FROM Orders O INNER JOIN Accounts A ON A.id = O.accountID WHERE O.status = ? AND O.creationDate LIKE ? GROUP BY O.accountID ORDER BY total DESC LIMIT $limit");
                        $topDonorList->execute(array(1, date("Y-m-d") . "%"));
                        $topDonorList = $topDonorList->fetchAll(PDO::FETCH_ASSOC);
                        for ($i = 0; $i < count($topDonorList); $i++) {
                            $topDonorList[$i]["id"] = $i + 1;
                            $topDonorList[$i]["total"] = money($topDonorList[$i]["total"]);
                        }
                        response()->json($topDonorList);
                    }
		                if (get("get") == "top_donors" && get("from") && get("to")) {
			                $from = date('Y-m-d 00:00:00', strtotime(get("from")));
			                $to = date('Y-m-d 23:59:59', strtotime(get("to")));
			                
			                $topDonorList = db()->prepare("SELECT A.id as userID, A.username, A.realname as displayName, SUM(O.earnings) as total FROM Orders O INNER JOIN Accounts A ON A.id = O.accountID WHERE O.status = ? AND O.creationDate >= ? AND O.creationDate <= ? GROUP BY O.accountID ORDER BY total DESC LIMIT 5");
			                $topDonorList->execute(array(1, $from, $to));
			                $topDonorList = $topDonorList->fetchAll(PDO::FETCH_ASSOC);
			                for ($i = 0; $i < count($topDonorList); $i++) {
				                $topDonorList[$i]["id"] = $i + 1;
				                $topDonorList[$i]["total"] = money($topDonorList[$i]["total"]);
			                }
			                response()->json($topDonorList);
		                }
                }
            } else {
                response()->json([
                    'status' => false
                ]);
            }
        } else {
            response()->json([
                'status' => false
            ]);
        }
    }
		
		private function getSubcategoryIds($parentId) {
			$query = "SELECT id FROM ProductCategories WHERE parentID = :parentId";
			$stmt = db()->prepare($query);
			$stmt->execute(['parentId' => $parentId]);
			$subcategories = $stmt->fetchAll(PDO::FETCH_COLUMN);
			
			$allSubcategoryIds = $subcategories;
			
			foreach ($subcategories as $subcategoryId) {
				$allSubcategoryIds = array_merge($allSubcategoryIds, self::getSubcategoryIds($subcategoryId));
			}
			
			return $allSubcategoryIds;
		}
}