<?php

namespace Dashboard\Controllers\Ajax;

use Curl\Curl;
use Dashboard\Core\Controller;
use Dashboard\Services\CategoryService;
use PDO;

class StoreCategoryController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_STORE');
    }

    public function index()
    {
        if (moduleIsDisabled('tebex_store')) {
	        $categories = db()->query("SELECT id, name, parentID FROM ProductCategories ORDER BY priority DESC");
	        $categories = $categories->fetchAll(PDO::FETCH_ASSOC);
	        
	        response()->json(
		        CategoryService::buildTree($categories)
	        );
        } else {
	        $createBasket = new Curl();
	        $createBasket->post('https://headless.tebex.io/api/accounts/'. moduleSettings('tebex_store', 'publicKey') .'/baskets', [
		        'username' => auth()->user()->displayName(),
		        //'ip_address' => getIP(),
	        ]);
	        $basketID = $createBasket->response->data->ident;
	        $categoryRequest = new Curl();
	        $categoryRequest->get('https://headless.tebex.io/api/accounts/' . moduleSettings('tebex_store', 'publicKey') . '/categories?basketIdent=' . $basketID);
	        if ($categoryRequest->error) {
		        response()->json([]);
	        }
	        $data = $categoryRequest->response->data;
	        
	        function buildTree($data, $parentId = null) {
		        $tree = [];
		        
		        foreach ($data as $item) {
			        if (($item->parent->id ?? null) === $parentId) {
				        $children = buildTree($data, $item->id);
				        if ($children) {
					        $item->subcategories = $children;
				        } else {
					        $item->subcategories = [];
				        }
				        if (isset($item->parent)) {
					        unset($item->parent);
				        }
				        $tree[] = $item;
			        }
		        }
		        
		        return $tree;
	        }
	        $tree = buildTree($data);
					response()->json($tree);
        }
    }
}