<?php

namespace Dashboard\Controllers;

use Dashboard\Core\Controller;

class AnnouncementController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_ANNOUNCEMENTS');
    }

    public function index()
    {
        $announcements = db()->query("SELECT * FROM Broadcast ORDER BY id ASC");
        $announcements = $announcements->fetchAll();
        return view('announcements.index', compact('announcements'));
    }

    public function create()
    {
        return view('announcements.create');
    }

    public function store()
    {
        validate([
            'title' => 'required',
            'url' => 'required',
        ]);

        $insertBroadcast = db()->prepare("INSERT INTO Broadcast (title, url) VALUES (?, ?)");
        $insertBroadcast->execute(array(input("title"), input("url")));
        return back()->flash("success", t__('Announcement has been added successfully!'));
    }

    public function edit($id)
    {
        $announcement = db()->prepare("SELECT * FROM Broadcast WHERE id = ?");
        $announcement->execute(array($id));
        $announcement = $announcement->fetch();

      if (!$announcement) return view('404');

        return view('announcements.edit', compact('announcement'));
    }

    public function update($id)
    {
        validate([
            'title' => 'required',
            'url' => 'required',
        ]);

        $updateBroadcast = db()->prepare("UPDATE Broadcast SET title = ?, url = ? WHERE id = ?");
        $updateBroadcast->execute(array(input("title"), input("url"), $id));
        return back()->flash("success", t__('Changes has been saved successfully!'));
    }

    public function destroy($id)
    {
        $deleteBroadcast = db()->prepare("DELETE FROM Broadcast WHERE id = ?");
        $deleteBroadcast->execute(array($id));
        return back();
    }
}