<?php

namespace Dashboard\Controllers\Appearance;

use Dashboard\Core\Controller;

class ThemeController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_THEME');
    }

    public function index()
    {
        $availableThemes = [];
        $themes = scandir(__ROOT__ . '/apps/main/app/views/themes');
        foreach ($themes as $theme) {
            if ($theme != '.' && $theme != '..' && is_dir(__ROOT__ . '/apps/main/app/views/themes/' . $theme)) {
                if ($theme != themeName())
                    $availableThemes[] = $theme;
            }
        }
        $availableThemesJS = "";
        foreach ($availableThemes as $theme) {
            $availableThemesJS .= "'" . $theme . "',";
        }

        return view('appearance.themes.index', compact('themes', 'availableThemes', 'availableThemesJS'));
    }

    public function install()
    {
        if (get("theme")) {
            installTheme(get("theme"));
        } else {
            die(false);
        }
    }

  public function set()
  {
    if (get("theme")) {
      updateSetting("themeName", get("theme"));
      updateSetting("updatedAt", time());
	    
	    global $readSettings;
	    $readSettings["themeName"] = get("theme");
			
	    // Check Update
	    checkUpdate(false);

      createLog("THEME_SETTINGS_UPDATED");
    }
    return back();
  }
}