<?php

namespace Dashboard\Controllers;

use Dashboard\Core\Controller;

class ApplicationController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_APPLICATIONS');
    }

    public function index()
    {
        if (isset($_GET["page"])) {
            if (!is_numeric($_GET["page"])) {
                $_GET["page"] = 1;
            }
            $page = intval(get("page"));
        } else {
            $page = 1;
        }

        $visiblePageCount = 5;
        $limit = 50;

        if (get("status") != null) {
            $applications = db()->prepare("SELECT COUNT(id) FROM Applications WHERE status = ?");
            $applications->execute(array(get("status")));
        } else {
            $applications = db()->query("SELECT COUNT(id) FROM Applications");
        }
        $itemsCount = $applications->fetchColumn();
        $pageCount = ceil($itemsCount / $limit);
        if ($page > $pageCount) {
            $page = 1;
        }
        $visibleItemsCount = $page * $limit - $limit;

        if (input("status") != NULL) {
            $applications = db()->prepare("SELECT AP.*, A.username, A.realname, AF.title FROM Applications AP INNER JOIN Accounts A ON A.id = AP.accountID INNER JOIN ApplicationForms AF ON AF.id = AP.formID WHERE AP.status = ? ORDER BY AP.id DESC LIMIT $visibleItemsCount, $limit");
            $applications->execute(array(get("status")));
        } else {
            $applications = db()->query("SELECT AP.*, A.username, A.realname, AF.title FROM Applications AP INNER JOIN Accounts A ON A.id = AP.accountID INNER JOIN ApplicationForms AF ON AF.id = AP.formID ORDER BY AP.id DESC LIMIT $visibleItemsCount, $limit");
        }

        if (isset($_GET["search"])) {
            if (get("search") != null) {
                $applications = db()->prepare("SELECT AP.*, A.username, A.realname, AF.title FROM Applications AP INNER JOIN Accounts A ON A.id = AP.accountID INNER JOIN ApplicationForms AF ON AF.id = AP.formID WHERE (A.realname LIKE :search OR A.username LIKE :search) OR AF.title LIKE :search ORDER BY AP.id DESC");
                $applications->execute(array(
                    "search" => '%' . get("search") . '%'
                ));
            }
        }

        $applications = $applications->fetchAll();

        return view('applications.index', compact('applications', 'page', 'visiblePageCount', 'pageCount'));
    }

    public function show($id)
    {
        $application = db()->prepare("SELECT AP.*, A.username, A.realname, AF.title FROM Applications AP INNER JOIN Accounts A ON A.id = AP.accountID INNER JOIN ApplicationForms AF ON AP.formID = AF.id WHERE AP.id = ?");
        $application->execute(array($id));
        $application = $application->fetch();

        if (!$application) return view('404');

        $answers = db()->prepare("SELECT GROUP_CONCAT(AA.answer) as answer, AFQ.question FROM ApplicationAnswers AA INNER JOIN ApplicationFormQuestions AFQ ON AFQ.id = AA.questionID WHERE AA.applicationID = ? GROUP BY AFQ.id");
        $answers->execute(array($application["id"]));

        return view('applications.show', compact('application', 'answers'));
    }

    public function reject($id)
    {
        $updateApplication = db()->prepare("UPDATE Applications SET reason = ?, status = ? WHERE id = ?");
        $updateApplication->execute(array(input("reason"), 0, $id));
        return back()->flash("warning", t__('Application has been rejected!'));
    }

    public function approve($id)
    {
        $updateApplication = db()->prepare("UPDATE Applications SET reason = ?, status = ? WHERE id = ?");
        $updateApplication->execute(array(input("reason"), 1, $id));
        return back()->flash("success", t__('Application has been approved!'));
    }

    public function destroy($id)
    {
        $deleteApplication = db()->prepare("DELETE FROM Applications WHERE id = ?");
        $deleteApplication->execute(array($id));
        return back();
    }
}
