<?php

namespace Dashboard\Controllers;

use Dashboard\Core\Controller;

class ApplicationFormController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_APPLICATIONS');
    }

    public function index()
    {
        $forms = db()->query("SELECT * FROM ApplicationForms ORDER BY id DESC");
        $forms = $forms->fetchAll();
        return view('applications.forms.index', compact('forms'));
    }

    public function create()
    {
        return view('applications.forms.create');
    }

    public function store()
    {
        validate([
            'title' => 'required',
            'description' => 'required',
        ]);
	    
		    $slug = slugify(input("title"));

        $insertForms = db()->prepare("INSERT INTO ApplicationForms (title, slug, description, reappliable, creationDate) VALUES (?, ?, ?, ?, ?)");
        $insertForms->execute(array(input("title"), $slug, filteredContent($_POST["description"]), input("reappliable"), datetime()));

        $formID = db()->lastInsertId();
        foreach ($_POST["formQuestion"] as $key => $value) {
            if ($_POST["formQuestion"][$key] == '')
                continue;
            $_POST["formQuestion"][$key] = strip_tags($_POST["formQuestion"][$key]);
            $_POST["formQuestionType"][$key] = strip_tags($_POST["formQuestionType"][$key]);
            $_POST["formQuestionVariables"][$key] = ($_POST["formQuestionVariables"][$key] != null) ? strip_tags($_POST["formQuestionVariables"][$key]) : '-';
            $insertFormQuestions = db()->prepare("INSERT INTO ApplicationFormQuestions (formID, question, type, variables) VALUES (?, ?, ?, ?)");
            $insertFormQuestions->execute(array($formID, $_POST["formQuestion"][$key], $_POST["formQuestionType"][$key], $_POST["formQuestionVariables"][$key]));
        }

        return back()->flash("success", t__('Application Form has been added successfully!'));
    }

    public function edit($id)
    {
        $form = db()->prepare("SELECT * FROM ApplicationForms WHERE id = ?");
        $form->execute(array($id));
        $form = $form->fetch();

      if (!$form) return view('404');

        $questions = db()->prepare("SELECT * FROM ApplicationFormQuestions WHERE formId = ? AND isEnabled = ?");
        $questions->execute(array($id, 1));
        $questions = $questions->fetchAll();

        return view('applications.forms.edit', compact('form', 'questions'));
    }

    public function update($id)
    {
        validate([
            'title' => 'required',
            'description' => 'required',
        ]);
	    
		    $slug = slugify(input("title"));

        $updateForms = db()->prepare("UPDATE ApplicationForms SET title = ?, slug = ?, description = ?, reappliable = ? WHERE id = ?");
        $updateForms->execute(array(input("title"), $slug, filteredContent($_POST["description"]), input("reappliable"), $id));

        $formID = $id;
        $disableOldQuestions = db()->prepare("UPDATE ApplicationFormQuestions SET isEnabled = ? WHERE formID = ?");
        $disableOldQuestions->execute(array(0, $formID));
        foreach ($_POST["formQuestion"] as $key => $value) {
            if ($_POST["formQuestion"][$key] == '')
                continue;
            $_POST["formQuestion"][$key] = strip_tags($_POST["formQuestion"][$key]);
            $_POST["formQuestionType"][$key] = strip_tags($_POST["formQuestionType"][$key]);
            $_POST["formQuestionVariables"][$key] = ($_POST["formQuestionVariables"][$key] != null) ? strip_tags($_POST["formQuestionVariables"][$key]) : '-';
            $insertFormQuestions = db()->prepare("INSERT INTO ApplicationFormQuestions (formID, question, type, variables) VALUES (?, ?, ?, ?)");
            $insertFormQuestions->execute(array($formID, $_POST["formQuestion"][$key], $_POST["formQuestionType"][$key], $_POST["formQuestionVariables"][$key]));
        }
        return back()->flash("success", t__('Changes has been saved successfully!'));
    }

    public function destroy($id)
    {
        $deleteForm = db()->prepare("DELETE FROM ApplicationForms WHERE id = ?");
        $deleteForm->execute(array($id));
        return back();
    }
}