<?php

namespace Dashboard\Controllers;

use Dashboard\Core\Controller;

class BanController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_BANS');
    }

    public function index()
    {
				$search = null;
		    if (isset($_GET["search"])) {
			    $search = get("search");
		    }
			
        if (get("page")) {
          if (!is_numeric(get("page"))) {
            $_GET["page"] = 1;
          }
          $page = intval(get("page"));
        } else {
          $page = 1;
        }

        $visiblePageCount = 5;
        $limit = 50;

        $bans = db()->prepare("SELECT BA.id FROM BannedAccounts BA INNER JOIN Accounts A ON BA.accountID = A.id WHERE (BA.expiryDate > ? OR BA.expiryDate = ?) ORDER BY BA.id DESC");
        $bans->execute(array(datetime(), '1000-01-01 00:00:00'));
        $itemsCount = $bans->fetchColumn();
        $pageCount = ceil($itemsCount / $limit);
        if ($page > $pageCount) {
          $page = 1;
        }
        $visibleItemsCount = $page * $limit - $limit;

        if (input("status") != NULL) {
          $bans = db()->prepare("SELECT BA.*, A.username, A.realname FROM BannedAccounts BA INNER JOIN Accounts A ON BA.accountID = A.id WHERE BA.categoryID = ? AND (BA.expiryDate > ? OR BA.expiryDate = ?) ORDER BY BA.id DESC LIMIT $visibleItemsCount, $limit");
          $bans->execute(array(get("status"), datetime(), '1000-01-01 00:00:00'));
        } else {
          $bans = db()->prepare("SELECT BA.*, A.username, A.realname FROM BannedAccounts BA INNER JOIN Accounts A ON BA.accountID = A.id WHERE (BA.expiryDate > ? OR BA.expiryDate = ?) ORDER BY BA.id DESC LIMIT $visibleItemsCount, $limit");
          $bans->execute(array(datetime(), '1000-01-01 00:00:00'));
        }
	    
		    if ($search) {
			    $bans = db()->prepare("SELECT BA.*, A.username, A.realname FROM BannedAccounts BA INNER JOIN Accounts A ON BA.accountID = A.id WHERE (A.realname LIKE :search OR A.username LIKE :search) AND (BA.expiryDate > :nowDate OR BA.expiryDate = :unlimitedDate) ORDER BY BA.id DESC");
			    $bans->execute(array(
				    "search" => '%' . input("search") . '%',
				    "nowDate" => datetime(),
				    "unlimitedDate" => '1000-01-01 00:00:00'
			    ));
		    }

        $bans = $bans->fetchAll();

        return view('bans.index', compact('bans', 'page', 'visiblePageCount', 'pageCount'));
    }

    public function create()
    {
        $account = null;
        if (get("id")) {
          $account = db()->prepare("SELECT * FROM Accounts WHERE id = :user OR username = :user");
          $account->execute(array(
            'user' => get("id")
          ));
          $account = $account->fetch();
        }

        return view('bans.create', compact('account'));
    }

    public function store()
    {
        validate([
            'userID' => 'required',
            'categoryID' => 'required',
            'reasonID' => 'required',
            'durationStatus' => 'required',
            'duration' => 'required_if:durationStatus,1',
        ]);

        $account = db()->prepare("SELECT * FROM Accounts WHERE id = ?");
        $account->execute(array(input("userID")));
        $account = $account->fetch();

        if (!$account) {
            return back()->flash("error", t__('User not found!'));
        }

        if (input("durationStatus") == 0) {
            set_input("duration", '1000-01-01 00:00:00');
        } else {
            set_input("duration", createDuration(input("duration")));
        }

        $account["permissions"] = getPermissions($account["id"]);
        if (auth()->user()->can('SUPER_ADMIN') && checkPerm($account["permissions"], 'SUPER_ADMIN')) {
            return back()->flash("error", t__("You don't have access to do it!"));
        } else if (auth()->user()->id() == $account["id"]) {
            return back()->flash("error", t__("You can't ban yourself!"));
        } else {
            if (input("categoryID") == 1) {
                $deleteAccountSessions = db()->prepare("DELETE FROM AccountSessions WHERE accountID = ?");
                $deleteAccountSessions->execute(array($account["id"]));
            }
            $insertBannedAccounts = db()->prepare("INSERT INTO BannedAccounts (accountID, categoryID, reasonID, expiryDate, creationDate) VALUES (?, ?, ?, ?, ?)");
            $insertBannedAccounts->execute(array($account["id"], input("categoryID"), input("reasonID"), input("duration"), datetime()));
            return back()->flash("success", t__('Account has been banned successfully!'));
        }
    }

    public function edit($id)
    {
        $ban = db()->prepare("SELECT BA.*, A.username, A.realname FROM BannedAccounts BA INNER JOIN Accounts A ON BA.accountID = A.id WHERE BA.id = ?");
        $ban->execute(array($id));
        $ban = $ban->fetch();

      if (!$ban) return view('404');

        return view('bans.edit', compact('ban'));
    }

    public function update($id)
    {
        validate([
            'categoryID' => 'required',
            'reasonID' => 'required',
            'durationStatus' => 'required',
            'duration' => 'required_if:durationStatus,1',
        ]);

        $bannedAccounts = db()->prepare("SELECT BA.*, A.username, A.realname FROM BannedAccounts BA INNER JOIN Accounts A ON BA.accountID = A.id WHERE BA.id = ?");
        $bannedAccounts->execute(array($id));
        $readBannedAccounts = $bannedAccounts->fetch();

        if (input("durationStatus") == 0) {
          set_input("duration", '1000-01-01 00:00:00');
        } else {
          set_input("duration", createDuration(input("duration")));
        }

        $readBannedAccounts["permissions"] = getPermissions($readBannedAccounts["id"]);
        if (auth()->user()->can('SUPER_ADMIN') && checkPerm($readBannedAccounts["permissions"], 'SUPER_ADMIN')) {
            return back()->flash("error", t__("You don't have access to do it!"));
        } else {
            if (input("categoryID") == 1) {
                $deleteAccountSessions = db()->prepare("DELETE FROM AccountSessions WHERE accountID = ?");
                $deleteAccountSessions->execute(array($readBannedAccounts["accountID"]));
            }
            $updateBannedAccounts = db()->prepare("UPDATE BannedAccounts SET categoryID = ?, reasonID = ?, expiryDate = ? WHERE id = ?");
            $updateBannedAccounts->execute(array(input("categoryID"), input("reasonID"), input("duration"), $id));
            return back()->flash("success", t__('Changes saved successfully!'));
        }
    }

    public function destroy($id)
    {
        $deleteBannedAccounts = db()->prepare("DELETE FROM BannedAccounts WHERE id = ?");
        $deleteBannedAccounts->execute(array($id));
        return back();
    }
}