<?php

namespace Dashboard\Controllers\Bazaar;

use Dashboard\Core\Controller;

class BazaarController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_BAZAAR');
    }

    public function index()
    {
        if (isset($_GET["page"])) {
            if (!is_numeric($_GET["page"])) {
                $_GET["page"] = 1;
            }
            $page = intval(get("page"));
        } else {
            $page = 1;
        }

        $visiblePageCount = 5;
        $limit = 50;

        $bazaar = db()->query("SELECT count(id) FROM BazaarItems");
        $itemsCount = $bazaar->fetchColumn();
        $pageCount = ceil($itemsCount / $limit);
        if ($page > $pageCount) {
            $page = 1;
        }
        $visibleItemsCount = $page * $limit - $limit;
        $bazaar = db()->query("SELECT BI.*, A.username, A.realname, S.name as serverName FROM BazaarItems BI INNER JOIN Accounts A ON A.id = BI.owner INNER JOIN BazaarServers S ON S.id = BI.serverID ORDER BY BI.id DESC LIMIT $visibleItemsCount, $limit");

        if (isset($_GET["search"])) {
            if (get("search") != null) {
                $bazaar = db()->prepare("SELECT BI.*, A.username, A.realname, S.name as serverName FROM BazaarItems BI INNER JOIN Accounts A ON A.id = BI.owner INNER JOIN BazaarServers S ON S.id = BI.serverID WHERE (A.realname LIKE :search OR A.username LIKE :search) OR S.name LIKE :search OR BI.name LIKE :search ORDER BY BI.id DESC");
                $bazaar->execute(array(
                    "search" => '%' . get("search") . '%'
                ));
            }
        }
        $bazaarItems = $bazaar->fetchAll();

        return view('bazaar.index', compact('bazaarItems', 'page', 'visiblePageCount', 'pageCount'));
    }

    public function edit($id)
    {
        $bazaarItem = db()->prepare("SELECT BI.*, S.name as serverName, A.username, A.realname, BCII.imageID, BCII.imageType FROM BazaarItems BI INNER JOIN Accounts A ON BI.owner = A.id LEFT JOIN BazaarCustomItemImages BCII ON BI.modelID IS NOT NULL AND BI.serverID = BCII.serverID AND BI.itemID = BCII.itemID AND BI.modelID = BCII.modelID INNER JOIN BazaarServers S ON S.id = BI.serverID WHERE BI.id = ?");
        $bazaarItem->execute(array($id));
        $bazaarItem = $bazaarItem->fetch();

	      if (!$bazaarItem) return view('404');

        return view('bazaar.edit', compact('bazaarItem'));
    }

    public function update($id)
    {
        validate([
            'price' => 'required',
        ]);

        $findAccount = db()->prepare("SELECT id FROM Accounts WHERE id = ?");
        $findAccount->execute(array(input("userID")));
        $readFindAccount = $findAccount->fetch();
        if ($findAccount->rowCount() == 0) {
            return back()->flash("error", t__('This player not found!'));
        }

        $updateProducts = db()->prepare("UPDATE BazaarItems SET price = ?, description = ?, owner = ? WHERE id = ?");
        $updateProducts->execute(array(input("price"), input("description"), $readFindAccount["id"], $id));
        return back()->flash("success", t__('Changes has been saved successfully!'));
    }

    public function destroy($id)
    {
        $deleteBazaarItem = db()->prepare("UPDATE BazaarItems SET price = ? WHERE id = ?");
        $deleteBazaarItem->execute(array(0, $id));
        return back();
    }
}