<?php

namespace Dashboard\Controllers\Bazaar;

use Dashboard\Core\Controller;
use Verot\Upload\Upload;

class CustomImagesController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_PAGES');
    }

    public function index()
    {
        $itemImages = db()->query("SELECT BCII.*, S.name as serverName FROM BazaarCustomItemImages BCII INNER JOIN BazaarServers S ON BCII.serverID = S.id ORDER BY BCII.id DESC");
        $itemImages = $itemImages->fetchAll();

        return view('bazaar.custom-item-images.index', compact('itemImages'));
    }

    public function create()
    {
        $servers = db()->query("SELECT * FROM BazaarServers");
        $servers = $servers->fetchAll();

        return view('bazaar.custom-item-images.create', compact('servers'));
    }

    public function store()
    {
        validate([
            'itemID' => 'required',
            'modelID' => 'required',
            'serverID' => 'required',
            'image' => 'required|uploaded_file',
        ]);

        $upload = new Upload($_FILES["image"]);
        $imageID = md5(uniqid(rand(0, 9999)));
        if ($upload->uploaded) {
            $upload->allowed = array("image/*");
            $upload->file_new_name_body = $imageID;
            $upload->process(__ROOT__ . "/apps/main/public/images/items/custom/");
            if ($upload->processed) {
                $insertBazaarCustomItemImage = db()->prepare("INSERT INTO BazaarCustomItemImages (itemID, modelID, serverID, imageID, imageType) VALUES (?, ?, ?, ?, ?)");
                $insertBazaarCustomItemImage->execute(array(input("itemID"), input("modelID"), input("serverID"), $imageID, $upload->file_dst_name_ext));
                return back()->flash("success", t__('Custom Item Image has been added successfully!'));
            }
        } else {
            return back()->flash("error", t__('An error occupied while uploading an image: %error%', ['%error%' => $upload->error]));
        }
    }

    public function edit($id)
    {
        $itemImage = db()->prepare("SELECT * FROM BazaarCustomItemImages WHERE id = ?");
        $itemImage->execute(array($id));
        $itemImage = $itemImage->fetch();

      if (!$itemImage) return view('404');

        $servers = db()->query("SELECT * FROM BazaarServers");
        $servers = $servers->fetchAll();

        return view('bazaar.custom-item-images.edit', compact('itemImage', 'servers'));
    }

    public function update($id)
    {
        validate([
            'itemID' => 'required',
            'modelID' => 'required',
            'serverID' => 'required',
        ]);

        if (input()->file('image')->size) {
            $upload = new Upload($_FILES["image"]);
            $imageID = md5(uniqid(rand(0, 9999)));
            if ($upload->uploaded) {
                $upload->allowed = array("image/*");
                $upload->file_overwrite = true;
                $upload->file_new_name_body = $imageID;
                $upload->process(__ROOT__ . "/apps/main/public/images/items/custom/");
                if ($upload->processed) {
                    $updateImages = db()->prepare("UPDATE BazaarCustomItemImages SET imageID = ?, imageType = ? WHERE id = ?");
                    $updateImages->execute(array($imageID, $upload->file_dst_name_ext, $id));
                } else {
                    return back()->flash("error", t__('An error occupied while uploading an image: %error%', ['%error%' => $upload->error]));
                }
            }
        }

        $updateBazaarCustomItemImages = db()->prepare("UPDATE BazaarCustomItemImages SET itemID = ?, modelID = ?, serverID = ? WHERE id = ?");
        $updateBazaarCustomItemImages->execute(array(input("itemID"), input("modelID"), input("serverID"), $id));
        return back()->flash("success", t__('Changes has been saved successfully!'));
    }

    public function destroy($id)
    {
        $deleteBazaarCustomItemImages = db()->prepare("DELETE FROM BazaarCustomItemImages WHERE id = ?");
        $deleteBazaarCustomItemImages->execute(array($id));
        return back();
    }
}