<?php

namespace Dashboard\Controllers\Bazaar;

use Dashboard\Core\Controller;

class LogController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_BAZAAR');
    }

    public function index()
    {
        if (isset($_GET["page"])) {
            if (!is_numeric($_GET["page"])) {
                $_GET["page"] = 1;
            }
            $page = intval(get("page"));
        } else {
            $page = 1;
        }

        $visiblePageCount = 5;
        $limit = 50;

        $bazaarLogs = db()->query("SELECT count(id) FROM BazaarHistory");
        $itemsCount = $bazaarLogs->fetchColumn();
        $pageCount = ceil($itemsCount / $limit);
        if ($page > $pageCount) {
            $page = 1;
        }
        $visibleItemsCount = $page * $limit - $limit;
        $bazaarLogs = db()->query("SELECT BH.*, BI.name as itemName, BI.price as itemPrice, A.username , A.username, A.realname FROM BazaarHistory BH INNER JOIN BazaarItems BI ON BH.itemID = BI.id INNER JOIN Accounts A ON A.id = BH.accountID ORDER BY BH.id DESC LIMIT $visibleItemsCount, $limit");

        if (isset($_GET["search"])) {
            if (get("search") != null) {
                $bazaarLogs = db()->prepare("SELECT BH.*, BI.name as itemName, BI.price as itemPrice, A.username, A.realname FROM BazaarHistory BH INNER JOIN BazaarItems BI ON BH.itemID = BI.id INNER JOIN Accounts A ON A.id = BH.accountID WHERE (A.realname LIKE :search OR A.username LIKE :search) ORDER BY BH.id DESC");
                $bazaarLogs->execute(array(
                    "search" => '%' . get("search") . '%'
                ));
            }
        }
        $bazaarLogs = $bazaarLogs->fetchAll();

        return view('bazaar.logs.index', compact('bazaarLogs', 'page', 'visiblePageCount', 'pageCount'));
    }

    public function destroy($id)
    {
        $deleteBazaarHistory = db()->prepare("DELETE FROM BazaarHistory WHERE id = ?");
        $deleteBazaarHistory->execute(array($id));
        return back();
    }
}