<?php
	namespace Dashboard\Controllers\Bazaar;
	
	use Dashboard\Core\Controller;
	use Verot\Upload\Upload;
	
	class ServerController extends Controller
	{
		public function __construct()
		{
			abort_perm('MANAGE_BAZAAR');
		}
		
		public function index()
		{
			$servers = db()->query("SELECT * FROM BazaarServers ORDER BY id DESC");
      $servers = $servers->fetchAll();

			return view('bazaar.servers.index', compact('servers'));
		}
		
		public function create()
		{
			return view('bazaar.servers.create');
		}
		
		public function store()
		{
			validate([
        'name' => 'required',
        'priority' => 'required',
        'isActive' => 'required',
				'image' => 'required|uploaded_file',
			]);
			
			$slug = slugify(input("name"));
			
			$upload = new Upload($_FILES["image"]);
			$imageID = md5(uniqid(rand(0, 9999)));
			if ($upload->uploaded) {
				$upload->allowed = array("image/*");
				$upload->file_new_name_body = $imageID;
				$upload->process(__ROOT__ . "/apps/main/public/images/bazaar/");
				if ($upload->processed) {
					$insertServer = db()->prepare("INSERT INTO BazaarServers (name, slug, imageID, imageType, priority, isActive) VALUES (?, ?, ?, ?, ?, ?)");
          $insertServer->execute(array(input("name"), $slug, $imageID, $upload->file_dst_name_ext, input("priority"), input("isActive")));
					return back()->flash("success", t__('Server has been added successfully!'));
				}
			} else {
          return back()->flash("error", t__('An error occupied while uploading an image: %error%', ['%error%' => $upload->error]));
      }
		}
		
		public function edit($id)
		{
			$server = db()->prepare("SELECT * FROM BazaarServers WHERE id = ?");
      $server->execute(array($id));
      $server = $server->fetch();

      if (!$server) return view('404');

			return view('bazaar.servers.edit', compact('server'));
		}
		
		public function update($id)
		{
			validate([
				'name' => 'required',
				'priority' => 'required',
        'isActive' => 'required',
			]);
			
			$slug = slugify(input("name"));
			
			if (input()->file('image')->size) {
				$upload = new Upload($_FILES["image"]);
				$imageID = md5(uniqid(rand(0, 9999)));
				if ($upload->uploaded) {
					$upload->allowed = array("image/*");
					$upload->file_overwrite = true;
					$upload->file_new_name_body = $imageID;
					$upload->process(__ROOT__ . "/apps/main/public/images/bazaar/");
					if ($upload->processed) {
						$updateServer = db()->prepare("UPDATE BazaarServers SET imageID = ?, imageType = ? WHERE id = ?");
            $updateServer->execute(array($imageID, $upload->file_dst_name_ext, $id));
					}
					else {
						return back()->flash("error", t__('An error occupied while uploading an image: %error%', ['%error%' => $upload->error]));
					}
				}
			}

      $updateServer = db()->prepare("UPDATE BazaarServers SET name = ?, slug = ?, priority = ?, isActive = ? WHERE id = ?");
      $updateServer->execute(array(input("name"), $slug, input("priority"), input("isActive"), $id));
			return back()->flash("success", t__('Changes has been saved successfully!'));
		}
		
		public function destroy($id)
		{
			$deleteServer = db()->prepare("DELETE FROM BazaarServers WHERE id = ?");
      $deleteServer->execute(array($id));
			return back();
		}
	}