<?php

namespace Dashboard\Controllers\Blog;

use Dashboard\Core\Controller;
use Dashboard\Services\SlugService;

class CategoryController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_BLOG');
    }

    public function index()
    {
        $categories = db()->query("SELECT * FROM NewsCategories ORDER BY id DESC");
        $categories = $categories->fetchAll();

        return view('blog.categories.index', compact('categories'));
    }

    public function create()
    {
        return view('blog.categories.create');
    }

    public function store()
    {
        validate([
            'name' => 'required',
        ]);
	    
	      $slug = SlugService::preventDuplicate(input("name"), 'NewsCategories');

        $insertNewsCategories = db()->prepare("INSERT INTO NewsCategories (name, slug) VALUES (?, ?)");
        $insertNewsCategories->execute(array(input("name"), $slug));
        return back()->flash("success", t__('Category has been added successfully!'));
    }

    public function edit($id)
    {
        $category = db()->prepare("SELECT * FROM NewsCategories WHERE id = ?");
        $category->execute(array($id));
        $category = $category->fetch();

	      if (!$category) return view('404');

        return view('blog.categories.edit', compact('category'));
    }

    public function update($id)
    {
        validate([
            'name' => 'required',
        ]);
	    
		    $category = db()->prepare("SELECT * FROM NewsCategories WHERE id = ?");
		    $category->execute(array($id));
		    $category = $category->fetch();
		    
		    if (!$category) return view('404');
	    
		    if ($category["name"] != input("name")) {
			    $slug = SlugService::preventDuplicate(input("name"), 'NewsCategories');
		    } else {
			    $slug = $category["slug"];
		    }
			
        $updateNewsCategories = db()->prepare("UPDATE NewsCategories SET name = ?, slug = ? WHERE id = ?");
        $updateNewsCategories->execute(array(input("name"), $slug, $id));
        return back()->flash("success", t__('Changes has been saved successfully!'));
    }

    public function destroy($id)
    {
        $deleteNewsCategory = db()->prepare("DELETE FROM NewsCategories WHERE id = ?");
        $deleteNewsCategory->execute(array($id));
        return back();
    }
}