<?php

namespace Dashboard\Controllers\Blog;

use Dashboard\Core\Controller;
use Dashboard\Services\AvatarService;

class CommentController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_BLOG');
    }

    public function index()
    {
        if (isset($_GET["page"])) {
            if (!is_numeric($_GET["page"])) {
                $_GET["page"] = 1;
            }
            $page = intval(get("page"));
        } else {
            $page = 1;
        }

        $visiblePageCount = 5;
        $limit = 50;

        $comments = db()->query("SELECT count(NC.id) FROM NewsComments NC INNER JOIN Accounts A ON NC.accountID = A.id INNER JOIN News N ON NC.newsID = N.id ORDER BY NC.id DESC");
        $itemsCount = $comments->fetchColumn();
        $pageCount = ceil($itemsCount / $limit);
        if ($page > $pageCount) {
            $page = 1;
        }
        $visibleItemsCount = $page * $limit - $limit;
        $comments = db()->query("SELECT NC.*, A.username, A.realname, N.slug as postSlug FROM NewsComments NC INNER JOIN Accounts A ON NC.accountID = A.id INNER JOIN News N ON NC.newsID = N.id ORDER BY NC.id DESC LIMIT $visibleItemsCount, $limit");

        if (isset($_GET["search"])) {
            if (get("search") != null) {
                $comments = db()->prepare("SELECT NC.*, A.username, A.realname, N.slug as postSlug FROM NewsComments NC INNER JOIN Accounts A ON NC.accountID = A.id INNER JOIN News N ON NC.newsID = N.id WHERE NC.message LIKE :search OR (A.realname LIKE :search OR A.username LIKE :search) ORDER BY NC.id DESC");
                $comments->execute(array(
                    "search" => '%' . get("search") . '%'
                ));
            }
        }
        $comments = $comments->fetchAll();

        return view('blog.comments.index', compact('comments', 'page', 'visiblePageCount', 'pageCount'));
    }

    public function edit($id)
    {
        $comment = db()->prepare("SELECT NC.*, A.username, A.realname, N.title as newsTitle, N.slug as postSlug FROM NewsComments NC INNER JOIN Accounts A ON NC.accountID = A.id INNER JOIN News N ON NC.newsID = N.id WHERE NC.id = ?");
        $comment->execute(array($id));
        $comment = $comment->fetch();

	      if (!$comment) return view('404');
				
				$comment["avatar"] = AvatarService::get($comment["accountID"], $comment["realname"]);

        return view('blog.comments.edit', compact('comment'));
    }

    public function update($id)
    {
        $newsComment = db()->prepare("SELECT NC.*, A.username, A.realname, N.title as newsTitle, N.slug as postSlug FROM NewsComments NC INNER JOIN Accounts A ON NC.accountID = A.id INNER JOIN News N ON NC.newsID = N.id WHERE NC.id = ?");
        $newsComment->execute(array($id));
        $readNewsComment = $newsComment->fetch();

        $changeStatus = ($readNewsComment["status"] == 0) ? '1' : '0';
        $updateNewsComments = db()->prepare("UPDATE NewsComments SET status = ? WHERE id = ?");
        $updateNewsComments->execute(array($changeStatus, $id));

        if ($changeStatus == '0') {
            return back()->flash("success", t__('The comment has been unconfirmed successfully!'));
        } else {
            return back()->flash("success", t__('The comment has been confirmed successfully!'));
        }
    }

    public function destroy($id)
    {
        $deleteNewsComment = db()->prepare("DELETE FROM NewsComments WHERE id = ?");
        $deleteNewsComment->execute(array($id));
        return back();
    }
}