<?php

namespace Dashboard\Controllers;

use Dashboard\Core\Controller;
use PDO;

class ChangelogTagController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_CHANGELOG');
    }

    public function index()
    {
        $tags = db()->query("SELECT * FROM ChangelogTags ORDER BY id DESC");
	      $tags = $tags->fetchAll(PDO::FETCH_ASSOC);

        return view('changelog.tags.index', compact('tags'));
    }

    public function create()
    {
        return view('changelog.tags.create');
    }

    public function store()
    {
        validate([
            'name' => 'required',
        ]);
				
        $insert = db()->prepare("INSERT INTO ChangelogTags (name, badgeCSS) VALUES (?, ?)");
		    $insert->execute(array(input("name"), input("badgeCSS")));
				
        return back()->flash("success", t__('Tag has been added successfully!'));
    }

    public function edit($id)
    {
        $tag = db()->prepare("SELECT * FROM ChangelogTags WHERE id = ?");
		    $tag->execute(array($id));
		    $tag = $tag->fetch();

        if (!$tag) return view('404');

        return view('changelog.tags.edit', compact('tag'));
    }

    public function update($id)
    {
		    validate([
			    'name' => 'required',
		    ]);

        $update = db()->prepare("UPDATE ChangelogTags SET name = ?, badgeCSS = ? WHERE id = ?");
	      $update->execute(array(input("name"), input("badgeCSS"), $id));
				
        return back()->flash("success", t__('Changes has been saved successfully!'));
    }

    public function destroy($id)
    {
        $delete = db()->prepare("DELETE FROM ChangelogTags WHERE id = ?");
        $delete->execute(array($id));
				
        return back();
    }
}