<?php

namespace Dashboard\Controllers;

use Dashboard\Core\Controller;

class DownloadController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_DOWNLOADS');
    }

    public function index()
    {
        $files = db()->query("SELECT * FROM Downloads ORDER BY id DESC");
        $files = $files->fetchAll();

        return view('downloads.index', compact('files'));
    }

    public function create()
    {
        return view('downloads.create');
    }

    public function store()
    {
        validate([
            'name' => 'required',
            'content' => 'required',
            'downloadURL' => 'required',
        ]);
	    
		    $slug = slugify(input("name"));

        $insertDownloads = db()->prepare("INSERT INTO Downloads (name, slug, content, downloadURL) VALUES (?, ?, ?, ?)");
        $insertDownloads->execute(array(input("name"), $slug, filteredContent($_POST["content"]), input("downloadURL")));
        return back()->flash("success", t__('The Download File has been added successfully!'));
    }

    public function edit($id)
    {
        $file = db()->prepare("SELECT * FROM Downloads WHERE id = ?");
        $file->execute(array($id));
        $file = $file->fetch();

        if (!$file) return view('404');

        return view('downloads.edit', compact('file'));
    }

    public function update($id)
    {
        validate([
            'name' => 'required',
            'content' => 'required',
            'downloadURL' => 'required',
        ]);
	    
		    $slug = slugify(input("name"));

        $updateDownloads = db()->prepare("UPDATE Downloads SET name = ?, slug = ?, content = ?, downloadURL = ? WHERE id = ?");
        $updateDownloads->execute(array(input("name"), $slug, filteredContent($_POST["content"]), input("downloadURL"), $id));
        return back()->flash("success", t__('Changes has been saved successfully!'));
    }

    public function destroy($id)
    {
        $deleteDownload = db()->prepare("DELETE FROM Downloads WHERE id = ?");
        $deleteDownload->execute(array($id));
        return back();
    }
}