<?php

namespace Dashboard\Controllers;

use Dashboard\Core\Controller;
use PDO;

class FailedJobController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_LOGS');
    }

    public function index()
    {
        if (isset($_GET["page"])) {
            if (!is_numeric($_GET["page"])) {
                $_GET["page"] = 1;
            }
            $page = intval(get("page"));
        } else {
            $page = 1;
        }

        $visiblePageCount = 5;
        $limit = 50;

        $itemsCount = db()->query("SELECT count(id) FROM FailedJobs")->fetchColumn();
        $pageCount = ceil($itemsCount / $limit);
        if ($page > $pageCount) {
            $page = 1;
        }
        $visibleItemsCount = $page * $limit - $limit;
        $failedJobs = db()->query("SELECT * FROM FailedJobs ORDER BY id DESC LIMIT $visibleItemsCount, $limit");

        if (isset($_GET["search"])) {
	        $failedJobs = db()->prepare("SELECT * FROM FailedJobs WHERE name LIKE :search ORDER BY id DESC");
	        $failedJobs->execute(array(
		        "search" => '%' . get("search") . '%'
	        ));
        }
	    
		    $failedJobs = $failedJobs->fetchAll(PDO::FETCH_ASSOC);

        return view('failed-jobs.index', compact('failedJobs', 'page', 'visiblePageCount', 'pageCount'));
    }
	
		public function retry($id)
		{
			$failedJob = db()->prepare("SELECT * FROM FailedJobs WHERE id = ?");
			$failedJob->execute(array($id));
			$failedJob = $failedJob->fetch(PDO::FETCH_ASSOC);
			
			if (!$failedJob) return view('404');
			
			return back();
		}

    public function destroy($id)
    {
        $deleteFailedJob = db()->prepare("DELETE FROM FailedJobs WHERE id = ?");
	      $deleteFailedJob->execute(array($id));

        return back()->flash("success", t__('Failed job deleted successfully.'));
    }

    public function destroyAll()
    {
		    $deleteFailedJobs = db()->prepare("TRUNCATE TABLE FailedJobs");
		    $deleteFailedJobs->execute();

        return back()->flash("success", t__('All failed jobs deleted successfully.'));
    }
}