<?php

namespace Dashboard\Controllers;

use Dashboard\Core\Controller;

class FormAnswerController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_CUSTOM_FORMS');
    }

    public function index()
    {
        if (isset($_GET["page"])) {
            if (!is_numeric($_GET["page"])) {
                $_GET["page"] = 1;
            }
            $page = intval(get("page"));
        } else {
            $page = 1;
        }

        $visiblePageCount = 5;
        $limit = 50;

        if (get("status") != null) {
            $forms = db()->prepare("SELECT count(id) FROM Forms WHERE status = ?");
            $forms->execute(array(get("status")));
        } else {
            $forms = db()->query("SELECT count(id) FROM Forms");
        }

        $itemsCount = $forms->fetchColumn();
        $pageCount = ceil($itemsCount / $limit);
        if ($page > $pageCount) {
            $page = 1;
        }
        $visibleItemsCount = $page * $limit - $limit;

        if (get("status") != null) {
            $forms = db()->prepare("SELECT AP.*, A.username, A.realname, AF.title FROM Forms AP INNER JOIN Accounts A ON A.id = AP.accountID INNER JOIN CustomForms AF ON AF.id = AP.formID WHERE AP.status = ? ORDER BY AP.id DESC LIMIT $visibleItemsCount, $limit");
            $forms->execute(array(get("status")));
        } else {
            $forms = db()->query("SELECT AP.*, A.username, A.realname, AF.title FROM Forms AP INNER JOIN Accounts A ON A.id = AP.accountID INNER JOIN CustomForms AF ON AF.id = AP.formID ORDER BY AP.id DESC LIMIT $visibleItemsCount, $limit");
        }

        if (isset($_GET["search"])) {
            if (get("search") != null) {
                $forms = db()->prepare("SELECT AP.*, A.username, A.realname, AF.title FROM Forms AP INNER JOIN Accounts A ON A.id = AP.accountID INNER JOIN CustomForms AF ON AF.id = AP.formID WHERE (A.realname LIKE :search OR A.username LIKE :search) OR AF.title LIKE :search ORDER BY AP.id DESC");
                $forms->execute(array(
                    "search" => '%' . get("search") . '%'
                ));
            }
        }
        $forms = $forms->fetchAll();

        return view('forms.answers.index', compact('forms', 'page', 'visiblePageCount', 'pageCount'));
    }

    public function show($id)
    {
        $form = db()->prepare("SELECT AP.*, A.username, A.realname, AF.title FROM Forms AP INNER JOIN Accounts A ON A.id = AP.accountID INNER JOIN CustomForms AF ON AP.formID = AF.id WHERE AP.id = ?");
        $form->execute(array($id));
        $form = $form->fetch();

        if (!$form) return view('404');

        if (count($form) > 0) {
            $answers = db()->prepare("SELECT GROUP_CONCAT(AA.answer) as answer, AFQ.question FROM FormAnswers AA INNER JOIN CustomFormQuestions AFQ ON AFQ.id = AA.questionID WHERE AA.applicationID = ? GROUP BY AFQ.id");
            $answers->execute(array($form["id"]));

            return view('forms.answers.show', compact('form', 'answers'));
        }

        return view('404');
    }

    public function destroy($id)
    {
        $deleteForm = db()->prepare("DELETE FROM Forms WHERE id = ?");
        $deleteForm->execute(array($id));
        return back();
    }
}