<?php

namespace Dashboard\Controllers;

use Dashboard\Core\Controller;

class FormController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_CUSTOM_FORMS');
    }

    public function index()
    {
        $forms = db()->query("SELECT * FROM CustomForms ORDER BY id DESC");
        $forms = $forms->fetchAll();

        return view('forms.index', compact('forms'));
    }

    public function create()
    {
        return view('forms.create');
    }

    public function store()
    {
        validate([
            'title' => 'required',
            'description' => 'required'
        ]);
	    
		    $slug = slugify(input("title"));

        $insertForms = db()->prepare("INSERT INTO CustomForms (title, slug, description, creationDate) VALUES (?, ?, ?, ?)");
        $insertForms->execute(array(input("title"), $slug, filteredContent($_POST["description"]), datetime()));

        $formID = db()->lastInsertId();
        foreach ($_POST["formQuestion"] as $key => $value) {
            if ($_POST["formQuestion"][$key] == '')
                continue;
            $_POST["formQuestion"][$key] = strip_tags($_POST["formQuestion"][$key]);
            $_POST["formQuestionType"][$key] = strip_tags($_POST["formQuestionType"][$key]);
            $_POST["formQuestionVariables"][$key] = ($_POST["formQuestionVariables"][$key] != null) ? strip_tags($_POST["formQuestionVariables"][$key]) : '-';
            $insertFormQuestions = db()->prepare("INSERT INTO CustomFormQuestions (formID, question, type, variables) VALUES (?, ?, ?, ?)");
            $insertFormQuestions->execute(array($formID, $_POST["formQuestion"][$key], $_POST["formQuestionType"][$key], $_POST["formQuestionVariables"][$key]));
        }
        return back()->flash("success", t__('Custom Form has been added successfully!'));
    }

    public function edit($id)
    {
        $form = db()->prepare("SELECT * FROM CustomForms WHERE id = ?");
        $form->execute(array($id));
        $form = $form->fetch();

        if (!$form) return view('404');

        $questions = db()->prepare("SELECT * FROM CustomFormQuestions WHERE formId = ? AND isEnabled = ?");
        $questions->execute(array($id, 1));
        $questions = $questions->fetchAll();

        return view('forms.edit', compact('form', 'questions'));
    }

    public function update($id)
    {
        validate([
            'title' => 'required',
            'description' => 'required',
        ]);
	    
		    $slug = slugify(input("title"));

        $updateForms = db()->prepare("UPDATE CustomForms SET title = ?, slug = ?, description = ? WHERE id = ?");
        $updateForms->execute(array(input("title"), $slug, filteredContent($_POST["description"]), $id));

        $formID = $id;
        $disableOldQuestions = db()->prepare("UPDATE CustomFormQuestions SET isEnabled = ? WHERE formID = ?");
        $disableOldQuestions->execute(array(0, $formID));
        foreach ($_POST["formQuestion"] as $key => $value) {
            if ($_POST["formQuestion"][$key] == '')
                continue;
            $_POST["formQuestion"][$key] = strip_tags($_POST["formQuestion"][$key]);
            $_POST["formQuestionType"][$key] = strip_tags($_POST["formQuestionType"][$key]);
            $_POST["formQuestionVariables"][$key] = ($_POST["formQuestionVariables"][$key] != null) ? strip_tags($_POST["formQuestionVariables"][$key]) : '-';
            $insertFormQuestions = db()->prepare("INSERT INTO CustomFormQuestions (formID, question, type, variables) VALUES (?, ?, ?, ?)");
            $insertFormQuestions->execute(array($formID, $_POST["formQuestion"][$key], $_POST["formQuestionType"][$key], $_POST["formQuestionVariables"][$key]));
        }

        return back()->flash("success", t__('Changes has been saved successfully!'));
    }

    public function destroy($id)
    {
        $deleteForm = db()->prepare("DELETE FROM CustomForms WHERE id = ?");
        $deleteForm->execute(array($id));
        return back();
    }
}