<?php

namespace Dashboard\Controllers;

use Dashboard\Core\Controller;
use PDO;
use Verot\Upload\Upload;

class ForumCategoryController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_FORUM');
    }

    public function index()
    {
        $categories = db()->query("SELECT * FROM ForumCategories ORDER BY id DESC");
        $categories = $categories->fetchAll(PDO::FETCH_ASSOC);

        return view('forum.categories.index', compact('categories'));
    }

    public function create()
    {
        $parentCategories = db()->query("SELECT * FROM ForumCategories ORDER BY id DESC");
        $parentCategories = $parentCategories->fetchAll(PDO::FETCH_ASSOC);

        $permissions = db()->query("SELECT * FROM ForumPermissions");
        $permissions = $permissions->fetchAll();

        $roles = db()->query("SELECT * FROM Roles");
        $roles = $roles->fetchAll();

        return view('forum.categories.create', compact('parentCategories', 'permissions', 'roles'));
    }

    public function store()
    {
        validate([
            'name' => 'required',
            'image' => 'required|uploaded_file',
        ]);
	    
		    $slug = slugify(input("name"));

        $upload = new Upload($_FILES["image"]);
        $imageID = md5(uniqid(rand(0, 9999)));
        if ($upload->uploaded) {
            $upload->allowed = array("image/*");
            $upload->file_new_name_body = $imageID;
            $upload->process(__ROOT__ . "/apps/main/public/images/forum/categories/");
            if ($upload->processed) {
                $insertForumCategories = db()->prepare("INSERT INTO ForumCategories (parentID, name, slug, description, imageID, imageType) VALUES (?, ?, ?, ?, ?, ?)");
                $insertForumCategories->execute(array(input("parentID"), input("name"), $slug, input("description"), $imageID, $upload->file_dst_name_ext));
                $categoryID = db()->lastInsertId();
                foreach ($_POST as $key => $value) {
                    if (substr($key, 0, 11) == "permission_") {
                        $roleAndPerm = explode("_", substr($key, 11));
                        $roleID = $roleAndPerm[0];
                        $permissionID = $roleAndPerm[1];
                        if (input($key) == 1) {
                            $insertForumRolePermissions = db()->prepare("INSERT INTO ForumRolePermissions (categoryID, roleID, permissionID) VALUES (?, ?, ?)");
                            $insertForumRolePermissions->execute(array($categoryID, $roleID, $permissionID));
                        }
                    }
                }
                return back()->flash("success", t__('Category has been added successfully!'));
            }
        } else {
            return back()->flash("error", t__('An error occupied while uploading an image: %error%', ['%error%' => $upload->error]));
        }
    }

    public function edit($id)
    {
        $category = db()->prepare("SELECT * FROM ForumCategories WHERE id = ?");
        $category->execute(array($id));
        $category = $category->fetch();

        if (!$category) return view('404');

        $parentCategories = db()->prepare("SELECT * FROM ForumCategories WHERE id != ? ORDER BY id DESC");
        $parentCategories->execute(array($id));
        $parentCategories = $parentCategories->fetchAll(PDO::FETCH_ASSOC);

        $availablePermissions = db()->prepare("SELECT * FROM ForumRolePermissions WHERE categoryID = ?");
        $availablePermissions->execute(array($category["id"]));
        $availablePermissions = $availablePermissions->fetchAll();

        $permissions = db()->query("SELECT * FROM ForumPermissions");
        $permissions = array_map(function ($permission) use ($availablePermissions) {
            $permission["roles"] = [];
            foreach ($availablePermissions as $availablePermission) {
                if ($availablePermission["permissionID"] == $permission["id"]) {
                    $permission["roles"][] = $availablePermission["roleID"];
                }
            }
            return $permission;
        }, $permissions->fetchAll());

        $roles = db()->query("SELECT * FROM Roles");
        $roles = $roles->fetchAll();

        return view('forum.categories.edit', compact('category', 'parentCategories', 'permissions', 'roles'));
    }

    public function update($id)
    {
        validate([
            'name' => 'required',
        ]);
	    
		    $slug = slugify(input("name"));

        if (input()->file('image')->size) {
            $upload = new Upload($_FILES["image"]);
            $imageID = md5(uniqid(rand(0, 9999)));
            if ($upload->uploaded) {
                $upload->allowed = array("image/*");
                $upload->file_overwrite = true;
                $upload->file_new_name_body = $imageID;
                $upload->process(__ROOT__ . "/apps/main/public/images/forum/categories/");
                if ($upload->processed) {
                    $updateForumCategories = db()->prepare("UPDATE ForumCategories SET imageID = ?, imageType = ? WHERE id = ?");
                    $updateForumCategories->execute(array($imageID, $upload->file_dst_name_ext, $id));
                } else {
                    return back()->flash("error", t__('An error occupied while uploading an image: %error%', ['%error%' => $upload->error]));
                }
            }
        }

        $updateForumCategories = db()->prepare("UPDATE ForumCategories SET parentID = ?, name = ?, slug = ?, description = ? WHERE id = ?");
        $updateForumCategories->execute(array(input("parentID"), input("name"), $slug, input("description"), $id));

        $deletePermissions = db()->prepare("DELETE FROM ForumRolePermissions WHERE categoryID = ?");
        $deletePermissions->execute(array($id));
        foreach ($_POST as $key => $value) {
            if (substr($key, 0, 11) == "permission_") {
                $roleAndPerm = explode("_", substr($key, 11));
                $roleID = $roleAndPerm[0];
                $permissionID = $roleAndPerm[1];
                if (input($key) == 1) {
                    $insertForumRolePermissions = db()->prepare("INSERT INTO ForumRolePermissions (categoryID, roleID, permissionID) VALUES (?, ?, ?)");
                    $insertForumRolePermissions->execute(array($id, $roleID, $permissionID));
                }
            }
        }

        return back()->flash("success", t__('Changes has been saved successfully!'));
    }

    public function destroy($id)
    {
        $deleteForumCategory = db()->prepare("DELETE FROM ForumCategories WHERE id = ?");
        $deleteForumCategory->execute(array($id));
        return back();
    }
}