<?php
	namespace Dashboard\Controllers;
	
	use Dashboard\Core\Controller;
	use Verot\Upload\Upload;
	
	class GameController extends Controller
	{
		public function __construct()
		{
			abort_perm('MANAGE_GAMES');
		}
		
		public function index()
		{
			$games = db()->query("SELECT * FROM Games ORDER BY id DESC");
      $games = $games->fetchAll();

			return view('games.index', compact('games'));
		}
		
		public function create()
		{
			return view('games.create');
		}
		
		public function store()
		{
			validate([
				'title' => 'required',
				'content' => 'required',
				'image' => 'required|uploaded_file',
			]);
			
			$slug = slugify(input("title"));
			
			$upload = new Upload($_FILES["image"]);
			$imageID = md5(uniqid(rand(0, 9999)));
			if ($upload->uploaded) {
				$upload->allowed = array("image/*");
				$upload->file_new_name_body = $imageID;
				$upload->process(__ROOT__ . "/apps/main/public/images/games/");
				if ($upload->processed) {
					$insertGames = db()->prepare("INSERT INTO Games (title, slug, imageID, imageType, content, creationDate) VALUES (?, ?, ?, ?, ?, ?)");
					$insertGames->execute(array(input("title"), $slug, $imageID, $upload->file_dst_name_ext, filteredContent($_POST["content"]), datetime()));
					return back()->flash("success", t__('Game has been added successfully!'));
				}
			} else {
                return back()->flash("error", t__('An error occupied while uploading an image: %error%', ['%error%' => $upload->error]));
            }
		}
		
		public function edit($id)
		{
			$game = db()->prepare("SELECT * FROM Games WHERE id = ?");
			$game->execute(array($id));
			$game = $game->fetch();

	    if (!$game) return view('404');

			return view('games.edit', compact('game'));
		}
		
		public function update($id)
		{
			validate([
				'title' => 'required',
				'content' => 'required',
			]);
			
			$slug = slugify(input("title"));
			
			if (input()->file('image')->size) {
				$upload = new Upload($_FILES["image"]);
				$imageID = md5(uniqid(rand(0, 9999)));
				if ($upload->uploaded) {
					$upload->allowed = array("image/*");
					$upload->file_overwrite = true;
					$upload->file_new_name_body = $imageID;
					$upload->process(__ROOT__ . "/apps/main/public/images/games/");
					if ($upload->processed) {
						$updateGames = db()->prepare("UPDATE Games SET imageID = ?, imageType = ? WHERE id = ?");
						$updateGames->execute(array($imageID, $upload->file_dst_name_ext, $id));
					}
					else {
						return back()->flash("error", t__('An error occupied while uploading an image: %error%', ['%error%' => $upload->error]));
					}
				}
			}
			
			$updateGames = db()->prepare("UPDATE Games SET title = ?, slug = ?, content = ? WHERE id = ?");
			$updateGames->execute(array(input("title"), $slug, filteredContent($_POST["content"]), $id));
			return back()->flash("success", t__('Changes has been saved successfully!'));
		}
		
		public function destroy($id)
		{
			$deleteGame = db()->prepare("DELETE FROM Games WHERE id = ?");
			$deleteGame->execute(array($id));
			return back();
		}
	}