<?php

namespace Dashboard\Controllers;

use Dashboard\Core\Controller;
use Dashboard\Services\ProductService;
use PDO;

class GiftController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_GIFTS');
    }

    public function index()
    {
        $gifts = db()->query("SELECT * FROM ProductGifts ORDER BY id DESC");
        $gifts = $gifts->fetchAll(PDO::FETCH_ASSOC);
        $gifts = array_map(function ($item) {
            /* gift type */
            if ($item['giftType'] == 1) {
                $product = db()->prepare("SELECT name FROM Products WHERE id = ?");
                $product->execute(array($item["gift"]));
                $product = $product->fetch();

                $item['productName'] = $product["name"];
            } else $item['productName'] = credits($item['gift']);

            /* redeemLimit */
            if ($item['redeemLimit'] != -1) {
                $productGiftsHistory = db()->prepare("SELECT * FROM ProductGiftsHistory WHERE giftID = ?");
                $productGiftsHistory->execute(array($item["id"]));
                $item['amountLeft'] = max($item["redeemLimit"] - $productGiftsHistory->rowCount(), 0);
            }

            return $item;
        }, (array)$gifts);

        return view('gifts.index', compact('gifts'));
    }

    public function create()
    {
        $categories = db()->query("SELECT id, name, parentID FROM ProductCategories ORDER BY priority DESC");
        $categories = $categories->fetchAll(PDO::FETCH_ASSOC);

        $products = db()->query("SELECT id, name, categoryID FROM Products ORDER BY priority DESC");
		    $products = array_map(function ($product) {
			    // Exclude products that have variables
			    $variables = db()->prepare("SELECT V.id FROM ProductVariables PV INNER JOIN StoreVariables V ON PV.variableID = V.id WHERE PV.productID = ?");
			    $variables->execute(array($product["id"]));
			    if ($variables->rowCount() > 0) {
				    return null;
			    }
			    
			    return $product;
		    }, $products->fetchAll(PDO::FETCH_ASSOC));
		    $products = array_filter($products);

        $productList = ProductService::buildTree($categories, $products);

        return view('gifts.create', compact('productList'));
    }

    public function store()
    {
        validate([
            'name' => 'required',
            'giftType' => 'required',
            'giftProduct' => 'required_if:giftType,1',
            'giftCredit' => 'required_if:giftType,2',
            'expiryDate' => 'required_without:neverExpires',
            'redeemLimit' => 'required_without:unlimitedRedeemLimit',
        ]);

        if (input("neverExpires")) {
            set_input("expiryDate", '1000-01-01 00:00:00');
        }
        if (input("unlimitedRedeemLimit")) {
            set_input("redeemLimit", -1);
        }

        $checkGiftName = db()->prepare("SELECT id FROM ProductGifts WHERE name = ?");
        $checkGiftName->execute(array(slugify(str_replace(" ", "", input("name")))));

        if (input("giftType") == 1) {
            set_input("gift", input("giftProduct"));
        } else {
            set_input("gift", input("giftCredit"));
        }

        if ($checkGiftName->rowCount() > 0) {
            return back()->flash("error", t__('This coupon has already been created with this name!'));
        } else {
            $insertProductGifts = db()->prepare("INSERT INTO ProductGifts (name, giftType, gift, redeemLimit, expiryDate, creationDate) VALUES (?, ?, ?, ?, ?, ?)");
            $insertProductGifts->execute(array(slugify(str_replace(" ", "", input("name"))), input("giftType"), input("gift"), input("redeemLimit"), input("expiryDate"), datetime()));
            return back()->flash("success", t__('Gift has been added successfully!'));
        }
    }

    public function edit($id)
    {
        $productGift = db()->prepare("SELECT * FROM ProductGifts WHERE id = ?");
        $productGift->execute(array($id));
        $gift = $productGift->fetch();

        if (!$gift) return view('404');

        $categories = db()->query("SELECT id, name, parentID FROM ProductCategories ORDER BY priority DESC");
        $categories = $categories->fetchAll(PDO::FETCH_ASSOC);

        $products = db()->query("SELECT id, name, categoryID FROM Products ORDER BY priority DESC");
		    $products = array_map(function ($product) {
			    // Exclude products that have variables
			    $variables = db()->prepare("SELECT V.id FROM ProductVariables PV INNER JOIN StoreVariables V ON PV.variableID = V.id WHERE PV.productID = ?");
			    $variables->execute(array($product["id"]));
			    if ($variables->rowCount() > 0) {
				    return null;
			    }
			    
			    return $product;
		    }, $products->fetchAll(PDO::FETCH_ASSOC));
		    $products = array_filter($products);

        $productList = ProductService::buildTree($categories, $products);

        return view('gifts.edit', compact('gift', 'productList'));
    }

    public function update($id)
    {
        validate([
            'name' => 'required',
            'giftType' => 'required',
            'giftProduct' => 'required_if:giftType,1',
            'giftCredit' => 'required_if:giftType,2',
		        'expiryDate' => 'required_without:neverExpires',
		        'redeemLimit' => 'required_without:unlimitedRedeemLimit',
        ]);
	    
		    if (input("neverExpires")) {
			    set_input("expiryDate", '1000-01-01 00:00:00');
		    }
		    if (input("unlimitedRedeemLimit")) {
			    set_input("redeemLimit", -1);
		    }

        if (input("giftType") == 1) {
          set_input("gift", input("giftProduct"));
        } else {
          set_input("gift", input("giftCredit"));
        }

        $productGift = db()->prepare("SELECT name FROM ProductGifts WHERE id = ?");
        $productGift->execute(array($id));
        $readProductGift = $productGift->fetch();

        $checkGiftName = db()->prepare("SELECT id FROM ProductGifts WHERE name = ?");
        $checkGiftName->execute(array(slugify(str_replace(" ", "", input("name")))));

        if ($readProductGift["name"] != slugify(str_replace(" ", "", input("name"))) && $checkGiftName->rowCount() > 0) {
            return back()->flash("error", t__('This coupon has already been created with this name!'));
        } else {
            $updateProductGifts = db()->prepare("UPDATE ProductGifts SET name = ?, giftType = ?, gift = ?, expiryDate = ?, redeemLimit = ? WHERE id = ?");
            $updateProductGifts->execute(array(slugify(str_replace(" ", "", input("name"))), input("giftType"), input("gift"), input("expiryDate"), input("redeemLimit"), $id));
            return back()->flash("success", t__('Changes has been saved successfully!'));
        }
    }

    public function destroy($id)
    {
        $deleteProductGift = db()->prepare("DELETE FROM ProductGifts WHERE id = ?");
        $deleteProductGift->execute(array($id));
        return back();
    }
}