<?php

namespace Dashboard\Controllers;

use Dashboard\Core\Controller;
use PDO;

class GiftLogController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_GIFTS');
    }

    public function index()
    {
        if (isset($_GET["page"])) {
            if (!is_numeric($_GET["page"])) {
                $_GET["page"] = 1;
            }
            $page = intval(get("page"));
        } else {
            $page = 1;
        }

        $visiblePageCount = 5;
        $limit = 50;

        $giftLogs = db()->query("SELECT COUNT(PGH.id) FROM ProductGiftsHistory PGH INNER JOIN Accounts A ON PGH.accountID = A.id INNER JOIN ProductGifts PG ON PGH.giftID = PG.id");
        $itemsCount = $giftLogs->fetchColumn();
        $pageCount = ceil($itemsCount / $limit);
        if ($page > $pageCount) {
            $page = 1;
        }
        $visibleItemsCount = $page * $limit - $limit;
        $giftLogs = db()->query("SELECT PGH.*, A.username, A.realname, PG.name as giftTitle FROM ProductGiftsHistory PGH INNER JOIN Accounts A ON PGH.accountID = A.id INNER JOIN ProductGifts PG ON PGH.giftID = PG.id ORDER BY PGH.id DESC LIMIT $visibleItemsCount, $limit");

        if (isset($_GET["search"])) {
            if (get("search") != null) {
                $giftLogs = db()->prepare("SELECT PGH.*, A.username, A.realname, PG.name as giftTitle FROM ProductGiftsHistory PGH INNER JOIN Accounts A ON PGH.accountID = A.id INNER JOIN ProductGifts PG ON PGH.giftID = PG.id WHERE (A.realname LIKE :search OR A.username LIKE :search) ORDER BY PGH.id DESC");
                $giftLogs->execute(array(
                    "search" => '%' . get("search") . '%'
                ));
            }
        }

        $giftLogs = $giftLogs->fetchAll();

        return view('gifts.logs.index', compact('giftLogs', 'page', 'visiblePageCount', 'pageCount'));
    }

    public function show($id)
    {
      $giftLog = db()->prepare("SELECT GH.*, G.giftType, G.gift, A.username, A.realname FROM ProductGiftsHistory GH INNER JOIN Accounts A ON GH.accountID = A.id INNER JOIN ProductGifts G ON GH.giftID = G.id WHERE GH.id = ?");
      $giftLog->execute(array($id));
      $giftLog = $giftLog->fetch(PDO::FETCH_ASSOC);

      if (!$giftLog) return view('404');

      $product = null;
      $commandLogs = null;
      if ($giftLog["giftType"] == 1) {
        $product = db()->prepare("SELECT P.name, PC.name as category FROM Products P INNER JOIN ProductCategories PC ON P.categoryID = PC.id WHERE P.id = ?");
        $product->execute(array($giftLog["gift"]));
        $product = $product->fetch(PDO::FETCH_ASSOC);
        if (!$product) return view('404');

        $commandLogs = db()->prepare("SELECT CL.id, CL.command, S.name as serverName, P.name as productName, CL.status, CL.updatedAt FROM CommandLogs CL INNER JOIN ProductCommands PC ON PC.id = CL.commandID INNER JOIN Servers S ON S.id = PC.serverID INNER JOIN Products P ON P.id = PC.productID WHERE CL.dataType = ? AND CL.dataID = ?");
        $commandLogs->execute(array('gift', $id));
	      $commandLogs = $commandLogs->fetchAll(PDO::FETCH_ASSOC);
      }

      return view('gifts.logs.show', compact('giftLog', 'product', 'commandLogs'));
    }

    public function destroy($id)
    {
        $deleteProductGiftsHistory = db()->prepare("DELETE FROM ProductGiftsHistory WHERE id = ?");
        $deleteProductGiftsHistory->execute(array($id));
        return back();
    }
}