<?php

namespace Dashboard\Controllers;

use Dashboard\Core\Controller;

class HomeController extends Controller
{
    public function index()
    {
        $tickets = [];
        $orders = [];

        if (auth()->user()->can('MANAGE_STORE')) {
            $orders = db()->prepare("SELECT O.*, A.username, A.realname FROM Orders O INNER JOIN Accounts A ON O.accountID = A.id WHERE O.status = ? ORDER BY O.id DESC LIMIT 5");
            $orders->execute([1]);
            $orders = $orders->fetchAll();
        }

        if (auth()->user()->can('MANAGE_SUPPORT_TICKETS')) {
          $tickets = db()->query("SELECT S.*, SC.name as categoryName, A.username, A.realname FROM Supports S INNER JOIN SupportCategories SC ON S.categoryID = SC.id INNER JOIN Accounts A ON S.accountID = A.id ORDER BY S.updateDate DESC LIMIT 5");
          $tickets = $tickets->fetchAll();
        }

        return view('home.index', compact('tickets', 'orders'));
    }
}