<?php

namespace Dashboard\Controllers;

use Dashboard\Core\Controller;

class LeaderboardController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_LEADERBOARDS');
    }

    public function index()
    {
        $leaderboards = db()->query("SELECT * FROM Leaderboards ORDER BY id DESC");
        $leaderboards = $leaderboards->fetchAll();
        return view('leaderboards.index', compact('leaderboards'));
    }

    public function create()
    {
        return view('leaderboards.create');
    }

    public function store()
    {
        validate([
            'serverName' => 'required',
            'mysqlServerStatus' => 'required',
            'mysqlServer' => 'required_if:mysqlServerStatus,1',
            'mysqlPort' => 'required_if:mysqlServerStatus,1',
            'mysqlUsername' => 'required_if:mysqlServerStatus,1',
            'mysqlPassword' => 'required_if:mysqlServerStatus,1',
            'mysqlDatabase' => 'required_if:mysqlServerStatus,1',
            'mysqlTable' => 'required',
            'usernameColumn' => 'required',
            'sorter' => 'required',
            'dataLimit' => 'required',
        ]);

        if (input("mysqlServerStatus") == 0) {
          set_input("mysqlServer", "0");
          set_input("mysqlPort", "0");
          set_input("mysqlUsername", "0");
          set_input("mysqlPassword", "0");
          set_input("mysqlDatabase", "0");
        }

        $tableTitles = rtrim(strip_tags(implode(",", str_replace(",", "", $_POST["tableTitles"]))), ",");
        $tableData = rtrim(strip_tags(implode(",", str_replace(",", "", $_POST["tableData"]))), ",");

        if ($tableTitles == null || $tableData == null) {
            return back()->flash('error', t__('Please fill all the fields!'));
        }
				
				$slug = slugify(input("serverName"));

        $insertLeaderboards = db()->prepare("INSERT INTO Leaderboards (serverName, serverSlug, mysqlServer, mysqlPort, mysqlUsername, mysqlPassword, mysqlDatabase, mysqlTable, usernameColumn, tableTitles, tableData, sorter, dataLimit) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $insertLeaderboards->execute(array(input("serverName"), $slug, input("mysqlServer"), input("mysqlPort"), input("mysqlUsername"), input("mysqlPassword"), input("mysqlDatabase"), input("mysqlTable"), input("usernameColumn"), $tableTitles, $tableData, input("sorter"), input("dataLimit")));
        return back()->flash("success", t__('Leaderboard has been added successfully!'));
    }

    public function edit($id)
    {
        $leaderboard = db()->prepare("SELECT * FROM Leaderboards WHERE id = ?");
        $leaderboard->execute(array($id));
        $leaderboard = $leaderboard->fetch();

      if (!$leaderboard) return view('404');

        return view('leaderboards.edit', compact('leaderboard'));
    }

    public function update($id)
    {
        validate([
            'serverName' => 'required',
            'mysqlServerStatus' => 'required',
            'mysqlServer' => 'required_if:mysqlServerStatus,1',
            'mysqlPort' => 'required_if:mysqlServerStatus,1',
            'mysqlUsername' => 'required_if:mysqlServerStatus,1',
            'mysqlPassword' => 'required_if:mysqlServerStatus,1',
            'mysqlDatabase' => 'required_if:mysqlServerStatus,1',
            'mysqlTable' => 'required',
            'usernameColumn' => 'required',
            'sorter' => 'required',
            'dataLimit' => 'required',
        ]);

        if (input("mysqlServerStatus") == 0) {
          set_input("mysqlServer", "0");
          set_input("mysqlPort", "0");
          set_input("mysqlUsername", "0");
          set_input("mysqlPassword", "0");
          set_input("mysqlDatabase", "0");
        }

        $tableTitles = rtrim(strip_tags(implode(",", str_replace(",", "", $_POST["tableTitles"]))), ",");
        $tableData = rtrim(strip_tags(implode(",", str_replace(",", "", $_POST["tableData"]))), ",");

        if ($tableTitles == null || $tableData == null) {
            return back()->flash('error', t__('Please fill all the fields!'));
        }
	    
		    $slug = slugify(input("serverName"));

        $updateLeaderboards = db()->prepare("UPDATE Leaderboards SET serverName = ?, serverSlug = ?, mysqlServer = ?, mysqlPort = ?, mysqlUsername = ?, mysqlPassword = ?, mysqlDatabase = ?, mysqlTable = ?, usernameColumn = ?, tableTitles = ?, tableData = ?, sorter = ?, dataLimit = ? WHERE id = ?");
        $updateLeaderboards->execute(array(input("serverName"), $slug, input("mysqlServer"), input("mysqlPort"), input("mysqlUsername"), input("mysqlPassword"), input("mysqlDatabase"), input("mysqlTable"), input("usernameColumn"), $tableTitles, $tableData, input("sorter"), input("dataLimit"), $id));

        return back()->flash("success", t__('Changes has been saved successfully!'));
    }

    public function destroy($id)
    {
        $deleteLeaderboard = db()->prepare("DELETE FROM Leaderboards WHERE id = ?");
        $deleteLeaderboard->execute(array($id));
        return back();
    }
}